package littlemaid.entity.ai;

import littlemaid.entity.EntityLittleMaid;
import littlemaid.entity.EnumMaidRole;
import net.minecraft.entity.EntityCreature;


public class EntityAIAttackOnCollide extends net.minecraft.entity.ai.EntityAIAttackOnCollide {

	/**
	 * 攻撃AIの初期化
	 * @param entity このAIタスクを所持するEntityCreatureインスタンス
	 * @param targetClass 攻撃対象になりうるエンティティクラスを限定する場合に指定する
	 * @param approachSpeed 攻撃時の移動速度
	 * @param longMemory 攻撃対象を見失ったくらいでタゲを切らない場合はtrue
	 */
	public EntityAIAttackOnCollide(EntityCreature entity, Class targetClass, double approachSpeed, boolean longMemory) {
		super(entity, targetClass, approachSpeed, longMemory);
        this.setMutexBits(4);
	}

	/**
	 * 攻撃AIの初期化
	 * @param entity このAIタスクを所持するEntityCreatureインスタンス
	 * @param approachSpeed 攻撃時の移動速度
	 * @param longMemory 攻撃対象を見失ったくらいでタゲを切らない場合はtrue
	 */
	public EntityAIAttackOnCollide(EntityCreature entity, double approachSpeed, boolean longMemory) {
		super(entity, approachSpeed, longMemory);
        this.setMutexBits(4);
	}

	@Override
	public boolean shouldExecute() {
		EntityLittleMaid maid = (EntityLittleMaid)this.attacker;

		// 待機状態
		if (maid.isWaiting()) return false;
		// アタッカーじゃない
		if (!maid.getRole().equals(EnumMaidRole.ATTACKER)) return false;
		// ご主人さまと同じディメンションにいない
		if (maid.dimension != maid.getOwner().dimension) return false;

		return super.shouldExecute();
	}

}
