unit BoardItem;

{
	ExternalBoardPlugIn BoardItem
	ێ TBoardItem NX
}

interface

uses
	Windows, SysUtils,
	PlugInMain, ThreadItem;

type
	// TBoardItem ̃vpeBݒ^擾 ID
	TBoardItemProperty = (
		bipContext,							// : DWORD				// Rɐݒ肵Ăl
		bipItems,								// : TThreadItem	// ɌqĂXbh
		bipNo,									// : Integer			// ԍ
		bipTitle,								// : string				// ^Cg
		bipRoundDate,						// : TDateTime		// 擾ij
		bipLastModified,				// : TDateTime		// XVĂiT[oj
		bipLastGetTime,					// : TDateTime		// Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
		bipRound,								// : Boolean			// \
		bipRoundName,						// : string				// 
		bipIsLogFile,						// : Boolean			// O݃tO
		bipUnRead,							// : Integer			// Xbhǐ
		bipURL,									// : string				// uEUŕ\ۂ URL
		bipFilePath,							// : string				// ̔ۑĂpX
		bipIs2ch							// : Boolean		//zXg2chǂ
	);

	// *************************************************************************
	// eX̏ԋp
	// *************************************************************************
	TBoardItemEnumThreadCallBack = function(
		inInstance	: DWORD;	// TBoardItem ̃CX^X
		inURL				: PChar;	// Xbh URL
		inTitle			: PChar;	// X^C
		inCount			: DWORD		// X̐
	) : Boolean; stdcall;		// 񋓂𑱂Ȃ True



	// =========================================================================
	// TBoardItem NXɊւ API
	// =========================================================================

	// *************************************************************************
	// BoardItemGetItems
	// TBoardItem NXɌqĂ TThreadItem NX擾
	// *************************************************************************
	TBoardItemGetItems = function(
		inInstance	: DWORD;	// TBoardItem ̃CX^X
		inIndex			: Integer	// 擾 TThreadItem ̃CfbNX
	) : DWORD; stdcall;			// TThreadItem ̃CX^X

	// *************************************************************************
	// BoardItemGetLong
	// TBoardItem NX̃vpeB擾
	// *************************************************************************
	TBoardItemGetLong = function(
		inInstance		: DWORD;							// TBoardItem ̃CX^X
		inPropertyID	: TBoardItemProperty	// 擾vpeB̎
	) : DWORD; stdcall;										// ߂l(Ӗ inPropertyID ɂĈقȂ)

	// *************************************************************************
	// BoardItemSetLong
	// TBoardItem NX̃vpeBݒ肷
	// *************************************************************************
	TBoardItemSetLong = procedure(
		inInstance		: DWORD;							// TBoardItem ̃CX^X
		inPropertyID	: TBoardItemProperty;	// ݒ肷vpeB̎
		inParam : DWORD											// ݒ肷l(Ӗ inPropertyID ɂĈقȂ)
	); stdcall;

	// *************************************************************************
	// BoardItemGetDouble
	// TBoardItem NX̃vpeB擾
	// *************************************************************************
	TBoardItemGetDouble = function(
		inInstance		: DWORD;							// TBoardItem ̃CX^X
	inPropertyID	: TBoardItemProperty	// 擾vpeB̎
	) : Double; stdcall;									// ߂l(Ӗ inPropertyID ɂĈقȂ)

	// *************************************************************************
	// BoardItemSetDouble
	// TBoardItem NX̃vpeBݒ肷
	// *************************************************************************
	TBoardItemSetDouble = procedure(
		inInstance		: DWORD;							// TBoardItem ̃CX^X
		inPropertyID	: TBoardItemProperty;	// ݒ肷vpeB̎
		inParam				: Double							// ݒ肷l(Ӗ inPropertyID ɂĈقȂ)
	); stdcall;

	// *************************************************************************
	// ۗLXꗗ̗񋓏vO{̂ɔC
	// *************************************************************************
	TBoardItemEnumThread = procedure(
		inInstance		: DWORD;							// TBoardItem ̃CX^X
		inCallBack		: TBoardItemEnumThreadCallBack;	// X̏ԋp郋[`
		inSubjectText	: PChar								// t@C,X^C(X) ō\s؂eLXg
	); stdcall;

	// *************************************************************************
	// BoardItemWork
	// _E[h̐i󋵂vO{̂ɓ`
	// *************************************************************************
	TBoardItemWork = procedure(
		inInstance	: DWORD;			// TBoardItem ̃CX^X
		inWorkCount	: DWORD				// ݂̐i(JEg)
	); stdcall;

	// *************************************************************************
	// BoardItemWorkBegin
	// _E[hn܂ƂvO{̂ɓ`
	// *************************************************************************
	TBoardItemWorkBegin = procedure(
		inInstance			: DWORD;	// TBoardItem ̃CX^X
		inWorkCountMax	: DWORD		// ʐM̏IJEg
	); stdcall;

	// *************************************************************************
	// BoardItemWorkEnd
	// _E[hIƂvO{̂ɓ`
	// *************************************************************************
	TBoardItemWorkEnd = procedure(
		inInstance	: DWORD				// TBoardItem ̃CX^X
	); stdcall;



	// =========================================================================
	// TBoardItem NXɊւCxg
	// =========================================================================

	// *************************************************************************
	// TBoardItem ꂽ
	// *************************************************************************
	TBoardItemOnCreateEvent = procedure(
		instance : DWORD
	);

	// *************************************************************************
	// TBoardItem jꂽ
	// *************************************************************************
	TBoardItemOnDisposeEvent = procedure(
		instance : DWORD
	);

	// *************************************************************************
	// _E[hwꂽ
	// *************************************************************************
	TBoardItemOnDownloadEvent = function : TDownloadState of object;

	// *************************************************************************
	// XĂwꂽ
	// *************************************************************************
	TBoardItemOnCreateThreadEvent = function(
		inSubject	: string;					// X^C
		inName		: string;					// O(nh)
		inMail		: string;					// [AhX
		inMessage	: string					// {
	) : TDownloadState of object;	// ݂ǂ

	// *************************************************************************
	// ̔ɂ̃X邩vꂽ
	// *************************************************************************
	TBoardItemOnEnumThreadEvent = procedure(
		inCallBack : TBoardItemEnumThreadCallBack
	) of object;

	// *************************************************************************
	// t@CXbh URL vꂽ
	// *************************************************************************
	TBoardItemOnFileName2ThreadURLEvent = function(
		inFileName : string
	) : string of object;


	// =========================================================================
	// TBoardItem NX
	// =========================================================================
	TBoardItem = class(TObject)
	private
		// NX̃CX^X
		FInstance							: DWORD;

		// _E[hwꂽ
		FOnDownload						: TBoardItemOnDownloadEvent;
		// XĂwꂽ
		FOnCreateThread				: TBoardItemOnCreateThreadEvent;
		// ̔ɂ̃X邩vꂽ
		FOnEnumThread					: TBoardItemOnEnumThreadEvent;
		// t@CXbh URL vꂽ
		FOnFileName2ThreadURL	: TBoardItemOnFileName2ThreadURLEvent;

	public
		// RXgN^
		constructor Create( inInstance : DWORD );

		// ۗLXꗗ̗񋓏vO{̂ɔC
		procedure	EnumThread( inCallBack : TBoardItemEnumThreadCallBack; inSubjectText : string );
		// _E[h̐i󋵂vO{̂ɓ`
		procedure	Work( inWorkCount : Integer );
		// _E[hn܂ƂvO{̂ɓ`
		procedure	WorkBegin( inWorkCountMax : Integer );
		// _E[hIƂvO{̂ɓ`
		procedure	WorkEnd;

	private
		// ===== vpeB̊Ǘ𓝊郉bp
		function	GetLong( propertyID : TBoardItemProperty ) : DWORD;
		procedure	SetLong( propertyID : TBoardItemProperty; param : DWORD );
		function	GetDouble( propertyID : TBoardItemProperty ) : Double;
		procedure	SetDouble( propertyID : TBoardItemProperty; param : Double );

		// ===== vpeB̎擾^ݒ𖖒[ɒ񋟂郉bp
		function	GetItems( index : Integer ) : TThreadItem;
		function	GetNo : Integer;
		procedure	SetNo( param : Integer );
		function	GetTitle : string;
		procedure	SetTitle( param : string );
		function	GetRoundDate : TDateTime;
		procedure	SetRoundDate( param : TDateTime );
		function	GetLastModified : TDateTime;
		procedure	SetLastModified( param : TDateTime );
		function	GetLastGetTime : TDateTime;
		procedure	SetLastGetTime( param : TDateTime );
		function	GetRound : Boolean;
		procedure	SetRound( param : Boolean );
		function	GetRoundName : string;
		procedure	SetRoundName( param : string );
		function	GetIsLogFile : Boolean;
		procedure	SetIsLogFile( param : Boolean );
		function	GetUnRead : Integer;
		procedure	SetUnRead( param : Integer );
		function	GetURL : string;
		procedure	SetURL( param : string );
		function	GetFilePath : string;
		procedure	SetFilePath( param : string );
		function	GetIs2ch	: Boolean;
		procedure	SetIs2ch( param : Boolean );

	protected
		property	Instance			: DWORD						read FInstance;

	public
		// ===== Cxg
		property	OnDownload			: TBoardItemOnDownloadEvent			read FOnDownload write FOnDownload;
		property	OnCreateThread	: TBoardItemOnCreateThreadEvent	read FOnCreateThread write FOnCreateThread;
		property	OnEnumThread		: TBoardItemOnEnumThreadEvent		read FOnEnumThread write FOnEnumThread;
		property	OnFileName2ThreadURL	: TBoardItemOnFileName2ThreadURLEvent	read FOnFileName2ThreadURL write FOnFileName2ThreadURL;

		// ===== ThreadItem Ɏ擾^ݒ\ȃvpeB
		// ɌqĂXbh
		property	Items[index : Integer] : TThreadItem	read GetItems;
		// ԍ
		property	No						: Integer					read GetNo write SetNo;
		// ^Cg
		property	Title					: string					read GetTitle write SetTitle;
		// 擾ij
		property	RoundDate			: TDateTime				read GetRoundDate write SetRoundDate;
		// XVĂiT[oj
		property	LastModified	: TDateTime				read GetLastModified write SetLastModified;
		// Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
		property	LastGetTime		: TDateTime				read GetLastGetTime write SetLastGetTime;
		// tO
		property	Round					: Boolean					read GetRound write SetRound;
		// 
		property	RoundName			: string					read GetRoundName write SetRoundName;
		// O݃tO
		property	IsLogFile			: Boolean					read GetIsLogFile write SetIsLogFile;
		// Xbhǐ
		property	UnRead				: Integer					read GetUnRead write SetUnRead;
		// uEUŕ\ۂ URL
		property	URL						: string					read GetURL write SetURL;
		// ̔ۑĂpX
		property	FilePath			: string					read GetFilePath write SetFilePath;
		//zXg2chǂ
		property	Is2ch				: Boolean		read GetIs2ch write SetIs2ch;
	end;

var
	// ===== API ̃AhX
	BoardItemGetItems	 	: TBoardItemGetItems;
	BoardItemGetLong	 	: TBoardItemGetLong;
	BoardItemSetLong	 	: TBoardItemSetLong;
	BoardItemGetDouble 	: TBoardItemGetDouble;
	BoardItemSetDouble	: TBoardItemSetDouble;
	BoardItemEnumThread	: TBoardItemEnumThread;
	BoardItemWork			 	: TBoardItemWork;
	BoardItemWorkBegin 	: TBoardItemWorkBegin;
	BoardItemWorkEnd	 	: TBoardItemWorkEnd;
	// ===== Cxgnh
	BoardItemOnCreate	 	: TBoardItemOnCreateEvent;
	BoardItemOnDispose 	: TBoardItemOnDisposeEvent;

// ===== TBoardItem NXǗ֐
procedure LoadInternalBoardItemAPI(
	inModule : HMODULE
);
procedure BoardItemOnCreateOfTBoardItem(
	inInstance : DWORD
);
procedure BoardItemOnDisposeOfTBoardItem(
	inInstance : DWORD
);

implementation

// *************************************************************************
// TBoardItem ̃RXgN^
// *************************************************************************
constructor TBoardItem.Create(
	inInstance : DWORD											// CX^X
);
begin

	inherited Create;
	FInstance 						:= inInstance;
	OnDownload						:= nil;
	OnCreateThread				:= nil;
	OnEnumThread					:= nil;
	OnFileName2ThreadURL	:= nil;

end;

// *************************************************************************
// ۗLXꗗ̗񋓏vO{̂ɔC
// *************************************************************************
procedure	TBoardItem.EnumThread(
	inCallBack		: TBoardItemEnumThreadCallBack;
	inSubjectText	: string	// t@C<>X^C ō\ꂽs؂eLXg
);
begin

	BoardItemEnumThread( FInstance, inCallBack, PChar( inSubjectText ) );

end;

// *************************************************************************
// _E[h̐i󋵂vO{̂ɓ`
// *************************************************************************
procedure	TBoardItem.Work(
	inWorkCount : Integer			// ݂̐i(JEg)
);
begin

	BoardItemWork( FInstance, inWorkCount );

end;

// *************************************************************************
// _E[hn܂ƂvO{̂ɓ`
// *************************************************************************
procedure	TBoardItem.WorkBegin(
	inWorkCountMax : Integer	// ʐM̏IJEg
);
begin

	BoardItemWorkBegin( FInstance, inWorkCountMax );

end;

// *************************************************************************
// _E[hIƂvO{̂ɓ`
// *************************************************************************
procedure	TBoardItem.WorkEnd;
begin

	BoardItemWorkEnd( FInstance );

end;



// =========================================================================
// TBoardItem ̃vpeB̊Ǘ𓝊郉bp
// =========================================================================
function	TBoardItem.GetLong( propertyID : TBoardItemProperty ) : DWORD;
begin
	Result := BoardItemGetLong( FInstance, propertyID );
end;

procedure	TBoardItem.SetLong( propertyID : TBoardItemProperty; param : DWORD );
begin
	BoardItemSetLong( FInstance, propertyID, param );
end;

function	TBoardItem.GetDouble( propertyID : TBoardItemProperty ) : Double;
begin
	Result := BoardItemGetDouble( FInstance, propertyID );
end;

procedure	TBoardItem.SetDouble( propertyID : TBoardItemProperty; param : Double );
begin
	BoardItemSetDouble( FInstance, propertyID, param );
end;



// =========================================================================
// 火
// TBoardItem ̃vpeB̎擾^ݒ𖖒[ɒ񋟂郉bp
// =========================================================================
function	TBoardItem.GetItems(
	index : Integer
) : TThreadItem;
var
	tmp : DWORD;
begin
	tmp			:= BoardItemGetItems( FInstance, index );
	Result	:= TThreadItem( ThreadItemGetLong( tmp, tipContext ) );
end;

function	TBoardItem.GetNo : Integer;
begin
	Result := GetLong( bipNo );
end;

procedure	TBoardItem.SetNo( param : Integer );
begin
	SetLong( bipNo, param );
end;

function	TBoardItem.GetTitle : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( bipTitle ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TBoardItem.SetTitle( param : string );
begin
	SetLong( bipTitle, DWORD( PChar( param ) ) );
end;

function	TBoardItem.GetRoundDate : TDateTime;
begin
	Result := GetDouble( bipRoundDate );
end;

procedure	TBoardItem.SetRoundDate( param : TDateTime );
begin
	SetDouble( bipRoundDate, param );
end;

function	TBoardItem.GetLastModified : TDateTime;
begin
	Result := GetDouble( bipLastModified );
end;

procedure	TBoardItem.SetLastModified( param : TDateTime );
begin
	SetDouble( bipLastModified, param );
end;

function	TBoardItem.GetLastGetTime : TDateTime;
begin
	Result := GetDouble( bipLastGetTime );
end;

procedure	TBoardItem.SetLastGetTime( param : TDateTime );
begin
	SetDouble( bipLastGetTime, param );
end;

function	TBoardItem.GetRound : Boolean;
begin
	Result := Boolean( GetLong( bipRound ) );
end;

procedure	TBoardItem.SetRound( param : Boolean );
begin
	SetLong( bipRound, DWORD( param ) );
end;

function	TBoardItem.GetRoundName : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( bipRoundName ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TBoardItem.SetRoundName( param : string );
begin
	SetLong( bipRoundName, DWORD( PChar( param ) ) );
end;

function	TBoardItem.GetIsLogFile : Boolean;
begin
	Result := Boolean( GetLong( bipIsLogFile ) );
end;

procedure	TBoardItem.SetIsLogFile( param : Boolean );
begin
	SetLong( bipIsLogFile, DWORD( param ) );
end;

function	TBoardItem.GetUnRead : Integer;
begin
	Result := GetLong( bipUnRead );
end;

procedure	TBoardItem.SetUnRead( param : Integer );
begin
	SetLong( bipUnRead, param );
end;

function	TBoardItem.GetURL : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( bipURL ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TBoardItem.SetURL( param : string );
begin
	SetLong( bipURL, DWORD( PChar( param ) ) );
end;

function	TBoardItem.GetFilePath : string;
var
	tmp : PChar;
begin
	tmp			:= PChar( GetLong( bipFilePath ) );
	Result	:= string( tmp );
	DisposeResultString( tmp );
end;

procedure	TBoardItem.SetFilePath( param : string );
begin
	SetLong( bipFilePath, DWORD( PChar( param ) ) );
end;

function	TBoardItem.GetIs2ch : Boolean;
begin
	Result := Boolean( GetLong( bipIs2ch ) );
end;

procedure	TBoardItem.SetIs2ch( param : Boolean );
begin
	SetLong( bipIs2ch, DWORD( param ) );
end;

// =========================================================================
// TBoardItem ̃vpeB̎擾^ݒ𖖒[ɒ񋟂郉bp
// ܂Ł
// =========================================================================




// =========================================================================
// TBoardItem NXǗ֐
// =========================================================================

// *************************************************************************
// TBoardItem ꂽꍇ̃ftHg̏u(TBoardItem 𐶐)
// *************************************************************************
procedure BoardItemOnCreateOfTBoardItem(
	inInstance : DWORD
);
var
	boardItem : TBoardItem;
begin

	boardItem := TBoardItem.Create( inInstance );
	boardItemSetLong( inInstance, bipContext, DWORD( BoardItem ) );

end;

// *************************************************************************
// TBoardItem jꂽꍇ̃ftHg̏u(TBoardItem j)
// *************************************************************************
procedure BoardItemOnDisposeOfTBoardItem(
	inInstance : DWORD
);
var
	boardItem : TBoardItem;
begin

	boardItem := TBoardItem( BoardItemGetLong( inInstance, bipContext ) );
	boardItem.Free;

end;

// *************************************************************************
// PlugInSDK  TBoardItem Ɋւ API 
// *************************************************************************
procedure LoadInternalBoardItemAPI(
	inModule : HMODULE
);
begin

	// ===== CX^X̃ftHg̎舵 TBoardItem ɂ
	BoardItemOnCreate	:= BoardItemOnCreateOfTBoardItem;
	BoardItemOnDispose	:= BoardItemOnDisposeOfTBoardItem;

	// ===== TBoardItem vpeB擾ݒ֐
	BoardItemGetItems := GetProcAddress( inModule, 'BoardItemGetItems' );
	if not Assigned( BoardItemGetItems ) then
		System.ExitCode := 1;
	BoardItemGetLong := GetProcAddress( inModule, 'BoardItemGetLong' );
	if not Assigned( BoardItemGetLong ) then
		System.ExitCode := 1;
	BoardItemSetLong := GetProcAddress( inModule, 'BoardItemSetLong' );
	if not Assigned( BoardItemSetLong ) then
		System.ExitCode := 1;
	BoardItemGetDouble := GetProcAddress( inModule, 'BoardItemGetDouble' );
	if not Assigned( BoardItemGetDouble ) then
		System.ExitCode := 1;
	BoardItemSetDouble := GetProcAddress( inModule, 'BoardItemSetDouble' );
	if not Assigned( BoardItemSetDouble ) then
		System.ExitCode := 1;
	BoardItemEnumThread := GetProcAddress( inModule, 'BoardItemEnumThread' );
	if not Assigned( BoardItemEnumThread ) then
		System.ExitCode := 1;
	BoardItemWork := GetProcAddress( inModule, 'BoardItemWork' );
	if not Assigned( BoardItemWork ) then
		System.ExitCode := 1;
	BoardItemWorkBegin := GetProcAddress( inModule, 'BoardItemWorkBegin' );
	if not Assigned( BoardItemWorkBegin ) then
		System.ExitCode := 1;
	BoardItemWorkEnd := GetProcAddress( inModule, 'BoardItemWorkEnd' );
	if not Assigned( BoardItemWorkEnd ) then
		System.ExitCode := 1;

end;



// =========================================================================
// TBoardItem NXɊւCxg
// =========================================================================

// *************************************************************************
// TBoardItem ꂽ
// *************************************************************************
procedure BoardItemCreate(
	inInstance : DWORD
); stdcall;
begin

	try
		BoardItemOnCreate( inInstance );
	except end;

end;

// *************************************************************************
// TBoardItem jꂽ
// *************************************************************************
procedure BoardItemDispose(
	inInstance : DWORD
); stdcall;
begin

	try
		BoardItemOnDispose( inInstance );
	except end;

end;

// *************************************************************************
// _E[hwꂽ
// *************************************************************************
function BoardItemOnDownload(
	inInstance	: DWORD					// CX^X
) : TDownloadState; stdcall;	// _E[hǂ
var
	context			: Pointer;
	boardItem	: TBoardItem;
begin

	try
		repeat
			context := Pointer( BoardItemGetLong( inInstance, bipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TBoardItem) then
				Break;

			boardItem := TBoardItem( context );
			if not Assigned( boardItem.OnDownload ) then
				Break;

			Result := boardItem.OnDownload;
			Exit;
		until True;
	except end;

	Result := dsError;

end;

// *************************************************************************
// XĂwꂽ
// *************************************************************************
function	BoardItemOnCreateThread(
	inInstance	: DWORD;				// BoardItem ̃CX^X
	inSubject		: PChar;				// X^C
	inName			: PChar;				// O(nh)
	inMail			: PChar;				// [AhX
	inMessage		: PChar					// {
) : TDownloadState; stdcall;	// ݂ǂ
var
	context			: Pointer;
	boardItem		: TBoardItem;
begin

	try
		repeat
			context := Pointer( BoardItemGetLong( inInstance, bipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TBoardItem) then
				Break;

			boardItem := TBoardItem( context );
			if not Assigned( boardItem.OnCreateThread ) then
				Break;

			Result := boardItem.OnCreateThread( string( inSubject ), string( inName ), string( inMail ), string( inMessage ) );
			Exit;
		until True;
	except end;

	Result := dsError;

end;

// *************************************************************************
// ̔ɂ̃X邩vꂽ
// *************************************************************************
procedure BoardItemOnEnumThread(
	inInstance	: DWORD;												// CX^X
	inCallBack	: TBoardItemEnumThreadCallBack	// ԋpׂR[obN
); stdcall;
var
	context			: Pointer;
	boardItem	: TBoardItem;
begin

	try
		repeat
			context := Pointer( BoardItemGetLong( inInstance, bipContext ) );
			if not Assigned( context ) then
				Break;

			if not Assigned( inCallBack ) then
				Break;

			if not (TObject( context ) is TBoardItem) then
				Break;

			boardItem := TBoardItem( context );
			if not Assigned( boardItem.OnEnumThread ) then
				Break;

			boardItem.OnEnumThread( inCallBack );
			Exit;
		until True;
	except end;

end;

// *************************************************************************
// t@CXbh URL vꂽ
// *************************************************************************
function BoardItemOnFileName2ThreadURL(
	inInstance	: DWORD;												// CX^X
	inFileName	: PChar													// ɂȂt@C
) : PChar; stdcall;
var
	context			: Pointer;
	boardItem		: TBoardItem;
begin

	try
		repeat
			context := Pointer( BoardItemGetLong( inInstance, bipContext ) );
			if not Assigned( context ) then
				Break;

			if not (TObject( context ) is TBoardItem) then
				Break;

			boardItem := TBoardItem( context );
			if not Assigned( boardItem.OnFileName2ThreadURL ) then
				Break;

			Result := CreateResultString( boardItem.OnFileName2ThreadURL( string( inFileName ) ) );
			Exit;
		until True;
	except end;

	Result := nil;

end;

exports
	BoardItemCreate,
	BoardItemDispose,
	BoardItemOnDownload,
	BoardItemOnCreateThread,
	BoardItemOnEnumThread,
	BoardItemOnFileName2ThreadURL;

end.
