/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __DRM_THREAD_SAFE_KEYED_VECTOR_H__
#define __DRM_THREAD_SAFE_KEYED_VECTOR_H__

#include <utils/threads.h>
#include <utils/KeyedVector.h>

namespace android {

template <typename KEY, typename VALUE>
class DrmThreadSafeKeyedVector {
public:
    inline void clear() {
        Mutex::Autolock lock(mLock);
        mVector.clear();
    }

    inline size_t size() const {
        Mutex::Autolock lock(mLock);
        return mVector.size();
    }

    inline bool isEmpty() const {
        Mutex::Autolock lock(mLock);
        return mVector.isEmpty();
    }

    ssize_t add(const KEY& key, const VALUE& item) {
        Mutex::Autolock lock(mLock);
        return mVector.add(key, item);
    }

    inline ssize_t indexOfKey(const KEY& key) const {
        Mutex::Autolock lock(mLock);
        return mVector.indexOfKey(key);
    }

    const VALUE& valueFor(const KEY& key) const {
        Mutex::Autolock lock(mLock);
        return mVector.valueFor(key);
    }

    inline ssize_t removeItem(const KEY& key) {
        Mutex::Autolock lock(mLock);
        return mVector.removeItem(key);
    }

    const KEY& keyAt(size_t index) const {
        Mutex::Autolock lock(mLock);
        return mVector.keyAt(index);
    }

    KeyedVector<KEY,VALUE> getVector() const {
        // Returns a copy of the vector
        Mutex::Autolock lock(mLock);
        return mVector;
    }

private:
    KeyedVector<KEY, VALUE> mVector;
    mutable Mutex mLock;
};
}

#endif /* __DRM_THREAD_SAFE_KEYED_VECTOR_H__ */
