/*
 * Copyright (C) 2009 The Android Open Source Project
 * Copyright (C) 2010 Sony Ericsson Mobile Communications AB. All rights reserved.
 * This file contains confidential and proprietary information of Sony Ericsson
 * Mobile Communications AB.
 *
 * Original code licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 *
 * NOTE: This file has been modified by Sony Ericsson Mobile Communications AB.
 * Modifications are licensed under the Sony Ericsson Mobile Communications AB's
 * End User License Agreement ("EULA"). Any use of the modifications is subject
 * to the terms of the EULA.
 */
/*Open DRM Framework change start*/
/*End of life for the patch is until the changes from Google
  are officially integrated to next release. Code is already
  in the AOSP master branch for review.
  https://review.source.android.com/#change,16142*/
#ifndef DRM_EXTRACTOR_H_

#define DRM_EXTRACTOR_H_

#include <media/stagefright/MediaExtractor.h>
#include <drm/DrmManagerClient.h>

namespace android {

struct AMessage;
class DataSource;
class SampleTable;
class String8;
class DecryptHandle;

class DRMExtractor : public MediaExtractor {
public:
    DRMExtractor(const sp<DataSource> &source, const char *mime);

    virtual size_t countTracks();
    virtual sp<MediaSource> getTrack(size_t index);
    virtual sp<MetaData> getTrackMetaData(size_t index, uint32_t flags);
    virtual sp<MetaData> getMetaData();

protected:
    virtual ~DRMExtractor();

private:
    struct SINF {
        SINF *next;
        uint16_t trackID;
        uint8_t IPMPDescriptorID;
        uint32_t len;
        char *IPMPData;
    };

    SINF *mFirstSINF;
    sp<DataSource> mDataSource;

    sp<MediaExtractor> mOriginalExtractor;
    sp<DecryptHandle> mDecryptHandle;
    status_t parseSINF();
    char *getSINF(int32_t index, int *len);
};

bool SniffDRM(
        const sp<DataSource> &source, String8 *mimeType, float *confidence, sp<AMessage> *);

}  // namespace android

#endif  // DRM_EXTRACTOR_H_
/*Open DRM Framework change end*/

