﻿using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Net;

namespace Rank00 {
    public partial class MainForm : Form {

        /* URL のサンプル
         * http://yuzuru.2ch.net/test/read.cgi/news4vip/1288709406/
         * http://yuzuru.2ch.net/test/read.cgi/news4vip/1290263979/
         * http://yuzuru.2ch.net/test/read.cgi/news4vip/1288277089/ (>>666-)
         */

        //string path = @"C:\Program Files\Live2ch\log\{server}\{board}\{dat}";

        int range = 1, rankMax = 20, from = 1;
        string[] ngId;

        bool downloadDat = false; // [TODO] とりあえず

        List<Res> resList = new List<Res>();

        readonly string[] separator = { "<>" };
        readonly TimeSpan oneDay = new TimeSpan(TimeSpan.TicksPerDay);
        Regex regex = new Regex(@"(\d\d:\d\d:\d\d.\d\d) ID:([0-9a-zA-Z\/+.]{8,})", RegexOptions.Compiled);

#if STOPWATCH
        System.Diagnostics.Stopwatch stopwatch = new System.Diagnostics.Stopwatch();
        long rapFile, rapParse, rapSort, rapString;
#endif

        public MainForm() {
            InitializeComponent();
        }

        private void rankButton_Click(object sender, EventArgs e){
            rankMax = (int)maxNumericUpDown.Value;
            from = (int)fromNumericUpDown.Value;

            rankButton.Enabled = false;
            Rank();
            rankButton.Enabled = true;
        }

        private void settingButton_Click(object sender, EventArgs e) {
            if (settingPanel.Visible) {
                settingButton.Text = "▼ 詳細設定";
                this.Height -= settingPanel.Height;
                buttonPanel.Top -= settingPanel.Height;
                resultPanel.Top -= settingPanel.Height;
                settingPanel.Visible = false;
            } else {
                settingButton.Text = "▲ 隠す";
                this.Height += settingPanel.Height;
                buttonPanel.Top += settingPanel.Height;
                resultPanel.Top += settingPanel.Height;
                settingPanel.Visible = true;
            }
        }

        /// <summary>
        /// ランキングを作成します。
        /// </summary>
        private void Rank() {
            Regex reg = new Regex(@"^h?ttp://([-\w.]+(?:/[-\w]+)*?)/test/read\.cgi/(\w+)/(\d{10})/",
                RegexOptions.ECMAScript);
            Match m = reg.Match(urlTextBox.Text);

            if (!m.Success) { // マッチしなかった
                urlTextBox.Focus();
                return;
            }

#if TRACE && !STOPWATCH
            string msg =
@"マッチしました。
サーバー：{0}
板：{1}
DAT：{2}";
            MessageBox.Show(string.Format(msg, m.Groups[1], m.Groups[2], m.Groups[3]), this.Text);
#endif

#if STOPWATCH
            stopwatch.Start();
#endif
            string[] lines;

            if (downloadDat) {
                WebClient client = new WebClient();
                client.Encoding = Encoding.GetEncoding("Shift_JIS");
                client.Headers.Add(HttpRequestHeader.UserAgent, "Monazilla/1.00 (Rank00/1.0)");

                lines = client.DownloadString(urlTextBox.Text).Split('\n');

            } else {
                string server = m.Groups[1].Value;
                string board = m.Groups[2].Value;
                string dat = m.Groups[3].Value;
                string path = pathTextBox.Text.Replace("{server}", server.Replace('/', '_'))
                                       .Replace("{board}", board)
                                       .Replace("{dat}", dat + ".dat");

                if (!File.Exists(path)) {
#if STOPWATCH
                    stopwatch.Reset();
#endif
                    MessageBox.Show("ファイルが見つかりません。\r\n" + path, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                    return;
                }

                lines = File.ReadAllLines(path, Encoding.GetEncoding("Shift_JIS"));
            }

#if STOPWATCH
            rapFile = stopwatch.ElapsedMilliseconds;
#endif

            if (ngidTextBox.TextLength != 0) {
                this.ngId = Array.FindAll<string>(ngidTextBox.Lines, str => str.Length >= 8);

                for (int i = 0, length = this.ngId.Length; i < length; i++) {
                    if (this.ngId[i].StartsWith("ID:"))
                        this.ngId[i] = this.ngId[i].Remove(0, 3);
                }

                if (this.ngId.Length == 0)
                    this.ngId = null;
            } else
                this.ngId = null;

            for (int i = from - 1, length = lines.Length; i < length; ++i) {
                m = this.regex.Match(lines[i].Split(this.separator, 4, StringSplitOptions.None)[2]);
                if (m.Success) {
                    TimeSpan distance = TimeSpan.Parse(m.Groups[1].Value);

                    if (distance.Hours >= 12)
                        distance -= this.oneDay;

                    if (distance.Duration().TotalSeconds <= this.range &&
                        (this.ngId == null || Array.IndexOf<string>(this.ngId, m.Groups[2].Value) == -1)) {

                        this.resList.Add(new Res(i + 1, distance, m.Groups[1].Value, m.Groups[2].Value));
#if TRACE && !STOPWATCH
                        MessageBox.Show("Distance: " + distance, this.Text);
#endif
                    }
                }
            }

            if (resList.Count == 0) {
#if STOPWATCH
                stopwatch.Reset();
#endif
                MessageBox.Show(string.Format("±{0}秒以内のレスがありませんでした", range));
                return;
            }
#if STOPWATCH
            rapParse = stopwatch.ElapsedMilliseconds;
#endif

            // 近い順に並び替える
            this.resList.Sort((a, b) => a.Duration.CompareTo(b.Duration));
#if STOPWATCH
            rapSort = stopwatch.ElapsedMilliseconds;
#endif

            StringBuilder result = new StringBuilder(string.Format(
@"　　　　{0:yyyy年MM月dd日} 00:00:00.00 ランキング{3}{4}
　±{1}秒以内に入った人： {2} 人
",
 DateTime.Today,
 this.range, this.resList.Count,
 this.from > 1 ? (" (>>" + this.from + "～)") : null,
 this.ngId != null ? " (除外有)" : null));

            long lastDuration = 0;

            for (int i = 0, length = resList.Count; i < length; ++i) {
                Res res = resList[i];

                string rankString;
                long duration = res.Duration;
                if (duration == 0)
                    rankString = "ネ申.";
                else if (duration == lastDuration)
                    rankString = " 　 　 ";
                else {
                    if (i >= rankMax) break;
                    rankString = (i < 9 ? ". " : null) + (i + 1) + "位 ";
                    lastDuration = duration;
                }

                string device = null;
                switch (res.ID[res.ID.Length - 1]) {
                    case '0':
                    case 'o':
                        device = "　(PC)";
                        break;
                    case 'O':
                    case 'Q':
                        device = "　(携帯)";
                        break;
                    case 'P':
                        device = "　(p2)";
                        break;
                    case 'I':
                    case 'i':
                        device = "　(iPhone)";
                        break;
                }

                result.AppendFormat("　{0}{1:+0.00sec ;-0.00sec ;　　　　　　}{2} >>{3} ID:{4}{5}{6}\r\n",
                    rankString, res.Distance.TotalSeconds, res.Time, res.Number, res.ID, device,
                    duration == 0 ? "　おめでとう！" : null);
            }
#if STOPWATCH
            rapString = stopwatch.ElapsedMilliseconds;
#endif

            if (!resultPanel.Visible) {
                autoCopyCheckBox.Visible = false;
                this.Height += resultPanel.Height - 28;
                resultPanel.Visible = true;
            }
            resultTextBox.Text = result.ToString();

            if (autoCopyCheckBox.Checked)
                Clipboard.SetText(result.ToString());
#if STOPWATCH
            stopwatch.Stop();

            MessageBox.Show(string.Format(
@"File: {0}ms
Parse: {1}ms
Sort: {2}ms
String: {3}ms
Show: {4}ms

Total: {5}ms",
             rapFile, rapParse - rapFile, rapSort - rapParse,
             rapString - rapSort, stopwatch.ElapsedMilliseconds - rapString,
             stopwatch.ElapsedMilliseconds), "RAP");

            stopwatch.Reset();
#endif

            this.resList.Clear();
        }

        private void closeButton_Click(object sender, EventArgs e) {
            autoCopyCheckBox.Visible = true;
            this.Height -= resultPanel.Height - 28;
            resultPanel.Visible = false;
        }

        private void copyButton_Click(object sender, EventArgs e) {
            Clipboard.SetText(resultTextBox.Text);
        }

        private void exitButton_Click(object sender, EventArgs e) {
            Close();
        }
    }

    struct Res {
        public int Number;
        public TimeSpan Distance;
        public string Time;
        public string ID;

        public long Duration {
            get { return this.Distance.Duration().Ticks; }
        }

        public Res(int number, TimeSpan distance, string time, string id) {
            this.Number = number;
            this.Distance = distance;
            this.Time = time;
            this.ID = id;
        }
    }
}
