package v1;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Inputer {

	//@V[hŎw肳ꂽeXg̗
	// filename nullȂ傫0̗Ԃ
	static List<Testcase> readSeed(String filename, InputFileData inputfiledata) {
		List<Testcase> seed = new ArrayList<Testcase>();
		if (filename == null)
			return seed;

		BufferedReader reader = openFile(filename);
		List<String> row = parseCSVRow(reader);

		//debug
		/*
		System.out.print("seed:");
		for (String str: row) {
			System.out.print(str + "\t");
		}
		System.out.println();
		*/
		
		// seed file ͋
		if (row == null)
			return seed;
		// parameters
		if (isParameterConsistent(row, inputfiledata) == false) {
			Error.printError("seedt@C̈q̋LqɌ肪܂");
			return null;
		}

		while ((row = parseCSVRow(reader)) != null) {
			// TODO debug
			//debug
			/*
			System.out.print("seed:");
			for (String str: row) {
				System.out.print(str + "\t");
			}
			System.out.println();
			*/
			
			/*
			  System.err.print(row.size() +": "); for (String str: row) {
			  System.err.print(str + ","); } System.err.println();
			 */

			/*
			 * if (isValueConsistent(row, inputfiledata) == false) {
			 * Error.printError("seedt@C̒l̋LqɌ肪܂"); return null; }
			 */

			
			// Testcase ƒǉ
			Testcase newtest = createTestcase(row, inputfiledata);
			
			
			if (newtest == null) {
				Error.printError("seedt@C̒l̋LqɌ肪܂");
				return null;
			} else {
				seed.add(newtest);
				// debug
				/*
				newtest.print();
				*/
			}
		}
		try {
			reader.close();
		} catch (IOException e) {
			Error.printError("seedt@CɃANZXł܂");
		}

		return seed;
	}
	
	private static Testcase createTestcase(List<String> row,
			InputFileData inputfiledata) {
		// lH
		Testcase newtest = new Testcase(inputfiledata.parameterList.size());
		int i = 0;
		for (i = 0; i < Math.min(row.size(), inputfiledata.parameterList.size()); i++) {
			String valuename = row.get(i);
			if (valuename.equals("")) {
				newtest.setWildCard(i);
				continue;
			}
			try {
				newtest.set(i, (byte) inputfiledata.parameterList.get(i).getID(valuename));
			} catch (NoValueNameException e) {
				return null;
			}
		}
		// sɑSp[^̒lȂ΁C󔒂
		for(; i < inputfiledata.parameterList.size(); i++) {
			newtest.setWildCard(i);
		}
		return newtest;
	}

	private static boolean isParameterConsistent(List<String> row,
			InputFileData inputfiledata) {
		//@q̃`FbN
		if (inputfiledata.parameterList.size() != row.size())
			return false;
		
		for (int i = 0; i < row.size(); i++) {
			try {
				if (inputfiledata.parameterList.getID(row.get(i)) != i) 
					return false;
			} catch (NoParameterNameException e) {
				return false;
			}
		}
		return true;
	}

	private static List<String> parseCSVRow(BufferedReader reader) {
		String line;
		List<String> tokenList = new ArrayList<String>();
		while (tokenList.size() == 0) {
			try {
				line = reader.readLine();
				if (line == null)
					break;
				
				//TODO ,̑Ő󔒂#̑Ő󔒂ƂāA,Zp[^
			//	line = line.replaceAll("#", ",#,");
				// #ȍ~
				line = line.replaceAll("#.*", "");
				// ,n܂ꍇCsɃXy[X
				// line = line.replaceAll(",", " ,");
				StringTokenizer st = new StringTokenizer(line, ",");
				while (st.hasMoreTokens()) {
					String token = st.nextToken();
					token = token.trim();
//					if (token.equals("#"))
//						break;
					token = token.trim();
					tokenList.add(token);
				}
			} catch (IOException e) {
				Error.printError("IO@G[");
				return null;
			}
			// 󔒂CRgȂ玟̍s
			boolean isAllEmpty = true;
			for (String token: tokenList) {
				if (token.equals("") == false) {
					isAllEmpty = false;
					break;
				}
			}
			if (isAllEmpty)
				tokenList.clear();
			//			if (tokenList.size() == 1)
			//				if (tokenList.get(0).equals(""))
			//		tokenList.remove(0);

		}
		
		if (tokenList.size() == 0)
			return null;
		else 
			return tokenList;
	}



	static InputFileData readModel(String filename){
		
		BufferedReader reader = openFile(filename);
		List<String> tokenList = makeTokenList(reader);
		TokenHandler t = new TokenHandler(tokenList);
		
		// qAl݂̂
		PList parameterList = readParameter(t);
		
		// eXg
		/*
		for(Parameter p: parameterList) {
			System.err.print(p.name + ": ");
			for (String name : p.value_name) {
				System.err.print(name + ", ");
			}
			System.err.println();
		}
		*/
	
		// O[v
		GList groupList = readGroup(t, parameterList);

		// eXg
		
		/*
		for(Group g: groupList) {
			for (int i = 0; i < g.size; i++)
				System.out.print(g.member[i] + ", ");
			System.out.println();
		}
		*/
		
		
		// 
		List<Node> constraintList = readConstraint(t, parameterList);
		
		// close 
		try {
			reader.close();
		} catch (IOException e) {
			Error.printError("̓t@CɃANZXł܂");
		}
		return new InputFileData(parameterList, groupList, constraintList);
	}
	
	private static List<Node> readConstraint(TokenHandler t, PList parameterList) {
		List<Node> constraintList = new ArrayList<Node>();
		while (true){
			if (t.peepToken() == null) {
				break;
			}
			Node n = new Parse(t, parameterList).parseExpression();
			constraintList.add(n);
		}
		return constraintList;
	}


	// O[v̓ǂݍ
	private static GList readGroup(TokenHandler t, PList parameterList) {
		GList groupList = new GList();
		while (true){
			if (t.peepToken() == null ||
					t.peepToken().equals("(")) {
				break;
			}
			try {
				if (t.getToken().equals("{") == false) {
					Error.printError("{ expected");
				}
			} catch (OutOfTokenStreamException e) {
				Error.printError("p[^wɌ肪܂");
			}
			// O[ṽp[^
			Set<Integer> memberSet = new TreeSet<Integer>(); 
			do {
				String name = null;
				try {
					name = t.getToken(); //`FbNĂȂ
				} catch (OutOfTokenStreamException e) {
					Error.printError("O[vwɌ肪܂");
				}
				try {
					/* debug 
					System.out.print(name + " " + parameterList.getID(name) + ", ");
					*/
					memberSet.add(Integer.valueOf(parameterList.getID(name)));
				} catch (NoParameterNameException e) {
					Error.printError("O[vwňqɌ肪܂");
				}
				if (t.peepToken() == null) {
					Error.printError("O[vwɌ肪܂");
				}
			} while (t.peepToken().equals("}") == false);
			Group g = new Group(memberSet);
			groupList.add(g);
			
			// } ݂̂
			try {
				t.getToken();
			} catch (OutOfTokenStreamException e) {
				Error.printError("O[vwɌ肪܂");
			}
		}
		//TODO group̐
		groupList.sort();
		// TODO dvf̍폜
		
		return groupList;
	}

	private static BufferedReader openFile(String filename) {
		BufferedReader reader = null;
		if (filename == null) {
			// default: standard input
			return new BufferedReader(new InputStreamReader(System.in));
		}
		
		try {
			reader = new BufferedReader(new FileReader(filename));
		} catch (FileNotFoundException e) {
			Error.printError("t@C" + filename + "܂D");
		}
		return reader;
	}
	
	private static List<String> makeTokenList(BufferedReader reader) {
		List<String> tokenList = new ArrayList<String>();
		String line;
		try {
			while ((line = reader.readLine()) != null) {
				line = line.replaceAll("\\(", " ( ");
				line = line.replaceAll("\\)", " ) ");

				line = line.replaceAll("#", " # ");

				line = line.replaceAll("\\{", " { ");
				line = line.replaceAll("\\}", " } ");
				
				line = line.replaceAll("\\[", " [ ");
				line = line.replaceAll("\\]", " ] ");
				
//				line = line.replaceAll(":", " : ");
				line = line.replaceAll(";", " ; ");
				
				StringTokenizer st = new StringTokenizer(line);
				while (st.hasMoreTokens()) {
					String token = st.nextToken();
					if (token.equals("#"))
						break;
					tokenList.add(token);
				}
			}
			reader.close();
		} catch (IOException e) {
			Error.printError(e.getMessage());
		}
		return tokenList;
	}

	// p[^̓ǂݍ
	private static PList readParameter(TokenHandler t) {
		PList parameterList = new PList();
		
		while (true) {
			try {
				if (t.peepToken() == null || t.peepToken().equals("{")
						|| t.peepToken().equals("(")) {
					break;
				}

				// p[^̖O
				// parameter name. Should be non-null
				String parameter_name = t.getToken();
				checkParameterName(parameter_name);
				Parameter p = new Parameter(parameter_name);

				if (t.getToken().equals("(") == false) {
					Error.printError("( ܂D");
				}
				// x̖O
				do {
					String level_name = t.getToken(); // `FbNĂȂ
					checkLevelName(level_name);
					p.addName(level_name);
					if (t.peepToken() == null) {
						Error.printError("p[^wɌ肪܂");
					}
				} while (t.peepToken().equals(")") == false);
				// ) ݂̂
				t.getToken();

				// l̏d`FbN
				p.check();

				parameterList.add(p);
			} catch (OutOfTokenStreamException e) {
				Error.printError("p[^wɌ肪܂");
			}
		}
		
		//@q̏d`FbN
		if (parameterList.checkNameDuplication())
			Error.printError("qdĂ܂");
		
		// q >= 2
		if (parameterList.size() < 2)
			Error.printError("q2ȏKvł");
		
		return parameterList;
	}

	private static void checkParameterName(String name) {
		// TODO Auto-generated method stub
		if (name.contains("(") || name.contains(")")
				|| name.contains("{") || name.contains("}") 
				|| name.contains("[") || name.contains("]") 
				|| name.contains(";") || name.contains(",") 
				) {
			Error.printError("qɋ֎~܂܂Ă܂");
		}	
	}

	private static void checkLevelName(String name) {
		// TODO Auto-generated method stub
		if (name.contains("(") || name.contains(")")
				|| name.contains("{") || name.contains("}") 
				|| name.contains("[") || name.contains("]") 
				|| name.contains(";") || name.contains(",") 
				) {
			Error.printError("ɋ֎~܂܂Ă܂");
		}	
	}


}
