﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Diagnostics;

namespace JoinNotes.Database
{
    //SQLServerCEではレコード1行あたり最大8060バイトまで
    [Table]
    public class Texts
    {
        [Column(IsPrimaryKey = true)]
        public string Filename { get; set; }

        [Column(IsPrimaryKey = true)]
        public long SerialNumber { get; set; }

        [Column]
        public string Text { get; set; }
    }

    //SQLServerCEではレコード1行あたり最大8060バイトまで
    [Table]
    public class Notes
    {
        static Notes()
        {
            Notes.db = new DataContext(Notes.File.FullName);
            Notes.Table_Notes = Notes.db.GetTable<Database.Notes>();
            Notes.Table_Texts = Notes.db.GetTable<Database.Texts>();
        }

        public static Table<Notes> Table_Notes { get; set; }
        public static Table<Texts> Table_Texts { get; set; }

        [Conditional("DEBUG")]
        public static void __t_Notes()
        {
            {
                var table = db.GetTable<Texts>();

                //FIXME: remove
                db.Log = Console.Out;

                foreach (var r in table)
                {
                    Debug.WriteLine(new { r.Filename, r.SerialNumber, r.Text });
                }
            }



            var note = new Notes();
            note.Filename = "123.txt";
            note.Entry = new EntryType { { "key", "value" } };
            Debug.Assert(note.Entry.Count == 1 && note.Entry.ContainsKey("key"));

            {
                var table = db.GetTable<Notes>();

                //FIXME: remove
                db.Log = Console.Out;

                {
                    var old = table.Where(_ => _ == note);
                    if (old.Count() > 0)
                    {
                        table.DeleteAllOnSubmit(old);
                        db.SubmitChanges();
                    }
                }

                var count1 = table.Count();

                table.InsertOnSubmit(note);

                db.SubmitChanges();

                Debug.Assert(table.Count() == count1 + 1);
            }

            {
                var table = db.GetTable<Notes>();

                //FIXME: remove
                db.Log = Console.Out;

                Debug.Assert(table.Count(_ => _.Filename == "123.txt") == 1);
                //HACK: System.NotSupportedException 「メンバー 'JoinNotes.Database.Notes.Entry' には、サポートされる SQL への変換がありません。」を回避するために型変換
                Debug.Assert(table.ToArray().Count(_ => _.Filename == "123.txt" && _.Entry.ContainsKey("key") && _.Entry["key"] as string == "value") == 1);
            }

        }

        public override string ToString()
        {
            //FIXME: Dataのフォーマット
            return string.Join(", ", new { this.Filename, Data = this.Data.ToString(), Text });
        }

        public override int GetHashCode()
        {
            return this.Filename.GetHashCode() ^ this.Data.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            return this.Filename == ((Notes)obj).Filename;
        }

        [Serializable]
        public class EntryType : Dictionary<string, object>
        {
            public EntryType()
                : base()
            {
            }

            public EntryType(SerializationInfo info, StreamingContext context)
                : base(info, context)
            {
            }

            //UNDONE: Serialize/Deserialize
            public override void OnDeserialization(object sender)
            {
                base.OnDeserialization(sender);
            }

            public override void GetObjectData(SerializationInfo info, StreamingContext context)
            {
                base.GetObjectData(info, context);
            }
        }

        /// <summary>
        /// DBテーブルでのData
        /// </summary>
        public EntryType Entry
        {
            get
            {
                if (this.Data.Length == 0)
                {
                    return new EntryType();
                }
                else
                {
                    using (var stream = new MemoryStream(this.Data))
                    {
                        var formatter = new BinaryFormatter();
                        //TODO: 戻り値は維持される？
                        return (EntryType)formatter.Deserialize(stream);
                    }
                }
            }

            set
            {
                using (var stream = new MemoryStream())
                {
                    var formatter = new BinaryFormatter();
                    formatter.Serialize(stream, (EntryType)value);

                    this.Data = stream.ToArray();
                }
            }
        }

        //private string[] Texts { get; set; }

        /// <summary>
        /// プレーンテキスト化したノート本文
        /// </summary>
        public string Text
        {
            get
            {
                // 複数レコードに分割されているので連結
                var texts = new StringBuilder();

                {
                    var table = Database.Notes.Table_Texts;

                    ////FIXME: remove
                    //db.Log = Console.Out;

                    foreach (var t in table.Where(_ => _.Filename == this.Filename).OrderBy(_ => _.SerialNumber))
                        texts.Append(t.Text);

                }

                return texts.ToString();
            }

            set
            {
                // 複数レコードに分割して格納
                var texts = new List<string> { };

                {
                    var table = Database.Notes.Table_Texts;

                    ////FIXME: remove
                    //db.Log = Console.Out;

                    //HACK: .ToArray()は高速化のため。
                    if (table.ToArray().Count(_ => _.Filename == this.Filename) > 0)
                        table.DeleteAllOnSubmit(table.Where(_ => _.Filename == this.Filename));

                    //TODO: DBに格納できる長さを検証
                    const int capacity = 4000;
                    long serialNumber = 0;
                    for (var i = 0; i < value.Length; i += capacity)
                    {
                        var text = value.Substring(i, Math.Min(value.Length, capacity));
                        //TODO: 既存レコードの削除
                        table.InsertOnSubmit(new Texts { Filename = this.Filename, SerialNumber = serialNumber, Text = text });

                        serialNumber++;
                    }

                    db.SubmitChanges();
                }
            }
        }

        [Column]
        private byte[] Data { get; set; }

        [Column(IsPrimaryKey = true)]
        public string Filename { get; set; }

        public static FileInfo File
        {
            get { return new FileInfo(Path.Combine(App.DocumentPath.FullName, @"JoinNotes.sdf")); }
        }

        public static DataContext db { get; private set; }

        //[Column]
        //public int WindowPosition_X { get; set; }

        //[Column]
        //public int WindowPosition_Y { get; set; }

        //[Column]
        //public int WindowSize_Width { get; set; }

        //[Column]
        //public int WindowSize_Height { get; set; }

    }
}
