﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;

namespace JoinNotes
{
    public static class __t
    {
        /// <summary>
        /// 同じアセンブリ内の__t_で始まるメソッドを実行する
        /// </summary>
        [Conditional("DEBUG")]
        public static void test()
        {
            // unit tests
            Debug.WriteLine("\n\ntesting now...\n==============\n\n");
            var asms = System.Reflection.Assembly.GetExecutingAssembly().GetLoadedModules();
            foreach (var a in asms)
            {
                var types = a.GetTypes();
                foreach (var t in types)
                {
                    var r = true;
                    var ms = t.GetMethods(System.Reflection.BindingFlags.Static | System.Reflection.BindingFlags.Public);
                    foreach (var m in ms.Where(m => Regex.IsMatch(m.Name, @"^__t_")))
                    {
                        if (r)
                        {
                            Debug.WriteLine("[" + t.FullName + "]");
                            Debug.Indent();
                            r = !r;
                        }
                        Debug.WriteLine(m.Name + ":");
                        m.Invoke(null, null);
                    }
                    if (!r)
                    {
                        Debug.WriteLine("done.");
                        Debug.Unindent();
                        Debug.WriteLine("");
                    }
                }
            }
            Debug.WriteLine("\n\nall testing done.\n\n");
        }

        public class EnumerableComparer<T> : IEqualityComparer<IEnumerable<T>>
        {
            public bool Equals(IEnumerable<T> x, IEnumerable<T> y)
            {
                return x.SequenceEqual(y);
            }

            public int GetHashCode(IEnumerable<T> obj)
            {
                return obj.Sum(e => e.GetHashCode() * 31);
            }
        }

        public delegate bool Comparer<T>(T a, T b);

        public static bool Equals<T>(IEnumerable<T> enumA, IEnumerable<T> enumB, Comparer<T> c = null)
        {
            if (c == null)
                c = delegate(T a, T b) { return (a == null) ? b == null : a.Equals(b); };

            return enumA.Count() == enumB.Count()
                && enumA.Zip(enumB, (a, b) => c(a, b)).All(r => r);
            //            return enumA.Count() == enumB.Count()
            //                && enumA.Zip(enumB, (a, b) => a.Equals(b)).All(r => r);
        }
    }
}
