package sdl4gcj;

public final class Sys implements SysConstants
{
	// system

	/**
	* SDL_Init()
	* Initialize SDL system.
	* <ul>
	* <li>SDL_INIT_TIMER</li>
	* <li>SDL_INIT_AUDIO</li>
	* <li>SDL_INIT_VIDEO</li>
	* <li>SDL_INIT_CDROM</li>
	* <li>SDL_INIT_JOYSTICK</li>
	* <li>SDL_INIT_NOPARACHUTE</li>
	* <li>SDL_INIT_EVENTTHREAD</li>
	* <li>SDL_INIT_EVERYTHING</li>
	* </ul>
	**/
	public static native final int init(int flags);

	/**
	* Initialize subsystem.
	* SDL_InitSubSystem()
	**/
	public static native final int initSubSystem(int flags);

	/**
	* Check which subsystems are initialized.
	* SDL_WasInit()
	**/
	public static native final int wasInit(int flags);

	/**
	* Finalize subsystem.
	* SDL_QuitSubSystem() 
	**/
	public static native final void quitSubSystem(int flags);

	/**
	* Finalize SDL system.
	* SDL_Quit()
	**/
	public static native final void quit();

	/**
	* Get version of compile library.
	* @return version of compile library 
	**/
	public static native Version compiledVersion();

	/**
	* Get version of linked library. ( SDL_Linked_Version() )
	* @return version of linked library
	**/
	public static native Version linkedVersion();

	/**
	* Wait a specified number of miliseconds.
	* SDL_Delay()
	* @param ms delay time (milisecond)
	**/
	public static native final void delay(long ms);

	/**
	* Get a number of miliseconds since the SDL system initialization.
	* SDL_GetTicks()
	**/
	public static native final long getTicks();

	/**
	* Get a native byte order.
	* SDL_BYTEORDER
	* @return byte order SDL_LIL_ENDIAN or SDL_BIG_ENDIAN 
	**/
	public static native final int byteOrder();

	private Sys(){}
}
