#include "sdl4gcj/Sys.h"
#include "sdl4gcj/Version.h"
#include "sdl4gcj/video/Surface.h"

#include <gcj/cni.h>
#include <SDL.h>

jint 
sdl4gcj::Sys::init (jint flags)
{
	JvInitClass(&sdl4gcj::Sys::class$);
	jint result = SDL_Init(flags);
	return result;
}

jint 
sdl4gcj::Sys::initSubSystem (jint flags)
{
	JvInitClass(&sdl4gcj::Sys::class$);
	jint result = SDL_InitSubSystem(flags);
	return result;
}

jint 
sdl4gcj::Sys::wasInit (jint flags)
{
	JvInitClass(&sdl4gcj::Sys::class$);
	jint result = SDL_WasInit(flags);
	return result;
}

void 
sdl4gcj::Sys::quitSubSystem (jint flags)
{
	JvInitClass(&sdl4gcj::Sys::class$);
	SDL_QuitSubSystem(flags);
}


void 
sdl4gcj::Sys::quit ()
{
	JvInitClass(&sdl4gcj::Sys::class$);
	SDL_Quit();
}

sdl4gcj::Version*
sdl4gcj::Sys::compiledVersion()
{
	JvInitClass(&sdl4gcj::Sys::class$);

	SDL_version nativeVersion;
	SDL_VERSION(&nativeVersion);

	sdl4gcj::Version* compiledVersion = new Version(
		nativeVersion.major,
		nativeVersion.minor,
		nativeVersion.patch);

	return compiledVersion;
}

sdl4gcj::Version*
sdl4gcj::Sys::linkedVersion()
{
	JvInitClass(&sdl4gcj::Sys::class$);

	const SDL_version* nativeVersion = SDL_Linked_Version();

	sdl4gcj::Version* linkedVersion = new Version(
		nativeVersion->major,
		nativeVersion->minor,
		nativeVersion->patch);

	return linkedVersion;
}

void 
sdl4gcj::Sys::delay (jlong ms)
{
	JvInitClass(&sdl4gcj::Sys::class$);
	SDL_Delay(ms);
}

jlong 
sdl4gcj::Sys::getTicks ()
{
	JvInitClass(&sdl4gcj::Sys::class$);
	return SDL_GetTicks();
}

jint 
sdl4gcj::Sys::byteOrder ()
{
	JvInitClass(&sdl4gcj::Sys::class$);
	return SDL_BYTEORDER;
}

