package sdl4gcj.cdrom;

public class CD implements CDConstants
{
	private static CD[] drives;

	// class methods
	private static CD[] getDrives() 
	{
		if (drives == null)
		{
			drives = new CD[getNumDrives()];
		}
		else if (getNumDrives() > drives.length)
		{
			CD[] newArray = new CD[getNumDrives()];
			for (int i = 0;i < drives.length;i++)
				newArray[i] = drives[i];
			drives = newArray;
		}
		return drives; 
	}

	/**
	* Returns the number of CD-ROM drives on the system.
	* @return the number of drives
	**/
	public static native int getNumDrives();
	public static CD getCD(int index)
	{
		CD cd;

		if (index < 0 || index >= CD.getNumDrives()) return null;

		CD[] cdDrives = getDrives();
		if (cdDrives[index] == null) 
			cdDrives[index] = new CD(index);
		cd = cdDrives[index];

		return cd;
	}

	public static CD getCD()
	{
		return CD.getCD(0);
	}

	public static CD[] getAllCD()
	{
		int num = CD.getNumDrives();
		CD[] cdList = new CD[num];
		for (int i = num-1;i >= 0;i--)
		{
			cdList[i] = CD.getCD(i);
		}

		return cdList;
	}

	public static int msfToFrames(int minute, int second, int frames)
	{
		return (minute * 60 + second) * CD_FPS + frames;
	}

	public static int framesToMinute(int frames)
	{
		return frames / CD_FPS / 60;
	}

	public static int framesToSecond(int frames)
	{
		return frames / CD_FPS % 60;
	}

	public static int framesToFrame(int frames)
	{
		return frames % CD_FPS;
	}

	// constructor
	private CD(int cdIndex)
	{
		this.index = cdIndex;
	}
	// instance method

	/**
	* Returns the human-readable identifier for the CD-ROM drive.
	* @return the name of this drive.
	**/
	public native String getName();

	/**
	* Returns the identifier for the CD-ROM drive.
	* @return the id of this drive.
	**/
	public int getIndex()
	{
		return this.index;
	}

	public native boolean isOpened();
	public native void open();
	public native void close();

	/**
	* Returns the current status of this drive.
	* @return  the current drive status. 
	* <ul>
	*  <li>CD_TRAYEMPTY</li> <li>CD_STOPPED</li> <li>CD_PLAYING</li>
	*  <li>CD_PAUSED</li> <li>CD_ERROR</li>
	* </ul>
	**/
	public native int getStatus();
	public native void play(int start_frame, int frame_length);
	public native void playTracks(int start_track, int start_frame, int ntracks, int nframes);
	public void playTracks(int start_track, int start_frame)
	{
		this.playTracks(start_track, start_frame, 0, 0);
	}
	public void playTracks()
	{
		this.playTracks(0, 0, 0, 0);
	}
	public native void pause();
	public native void resume();
	public native void stop();
	public native void eject();

	/**
	* Returns the disk status in this drive.
	* @return there is some CD in this drive, or not.
	**/
	public boolean inDrive()
	{
		return (this.getStatus() > 0);
	}

	/**
	* Returns the number of tracks current CD 
	* @return the number of tracks
	**/
	public native int getNumTracks();

	/**
	* Returns current track index
	**/
	public native int getCurrentTrack();

	/**
	* Returns current frame in current track 
	**/
	public native int getCurrentFrame();

	/**
	* Returns track infomations
	**/
	public native CDTrack[] getTracks();

	public String toString()
	{
		return super.toString() + "{" +
		"getName() : " + getName() + "," +
		"getIndex() : " + getIndex() + "}" ;
	}

	protected void finalize() throws Throwable
	{
		this.close();
		super.finalize();
	}

	private int index;
	private CDTrack[] tracks = new CDTrack[SDL_MAX_TRACKS];
	private gnu.gcj.RawData implementation;
}
