package sdl4gcj.input;

import sdl4gcj.SDLException;

public class Joystick implements JoystickConstants
{
	private static Joystick[] joysticks = null;

	// class methods
	private static Joystick[] getJoysticks() 
	{
		if (joysticks == null)
		{
			joysticks = new Joystick[Joystick.getNumJoysticks()];
		}
		else if (getNumJoysticks() > joysticks.length)
		{
			Joystick[] newArray = new Joystick[Joystick.getNumJoysticks()];
			for (int i = 0;i < joysticks.length;i++)
				newArray[i] = joysticks[i];
			joysticks = newArray;
		}
		return joysticks; 
	}

	public static native int getNumJoysticks();

	public static Joystick getJoystick(int index)
	{
		Joystick joystick;

		if (index < 0 || index >= Joystick.getNumJoysticks())
			throw new SDLException("No such joystick : " + index);

		Joystick[] sticks = getJoysticks();
		if (sticks[index] == null) 
			sticks[index] = new Joystick(index);
		joystick = sticks[index];

		return joystick;
	}

	public static Joystick getJoystick()
	{
		return Joystick.getJoystick(0);
	}

	public static Joystick[] getAllJoysticks()
	{
		int num = Joystick.getNumJoysticks();
		Joystick[] joysticks = new Joystick[num];

		for (int i = num-1;i >= 0;i--)
		{
			joysticks[i] = Joystick.getJoystick(i);
		}

		return joysticks;
	}

	// constructor
	private Joystick(int joystickIndex)
	{
		this.index = joystickIndex;
	}

	// instance method
	public int getIndex()
	{
		return this.index;
	}

	public native boolean isOpened();
	public native void open();
	public native void close();

	public native String getName();
	public native int getNumAxes();
	public native int getNumBalls();
	public native int getNumHats();
	public native int getNumButtons();

	public native int getAxis(int axisIndex);
	public native int getBallDX(int ballIndex);
	public native int getBallDY(int ballIndex);
	public native int getHat(int hatIndex);
	public native int getButton(int butotnIndex);

	public String toString()
	{
		return super.toString() + "\n" +
		"getName() : " + getName() + "\n" +
		"getIndex() : " + getIndex() + "\n" ;
	}

	protected void finalize() throws Throwable
	{
		this.close();
		super.finalize();
	}

	static private SDLException createNotOpenedException(int index, String name)
	{
		return new SDLException("Joystick " + index + "(" + name + ") is not opened.");
	}

	private int index;
	private gnu.gcj.RawData implementation;
}
