import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.input.*;
import sdl4gcj.event.*;

import java.io.*;

final public class InputStreamIconTest 
{
	public static void main(String[] args)
	{
		if (Sys.init(Sys.SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}

		try
		{
			Screen screen = Screen.setVideoMode(640, 480, 16, 
				Screen.SDL_SWSURFACE|Screen.SDL_ANYFORMAT);

			// load icon from icon_data
			InputStream is = new FileInputStream("images/icon.bmp");
			BufferedInputStream bis = new BufferedInputStream(is);
			Surface icon = Surface.loadBMP(bis);

			icon.setColorKey(Surface.SDL_SRCCOLORKEY|Surface.SDL_RLEACCEL);
			icon.displayFormat();

			int w = icon.getW();
			int h = icon.getH();
			int x = (screen.getW() - w) / 2;
			int y = (screen.getH() - h) / 2;

			screen.fillRect(screen.mapRGB(Color.BLACK));
			screen.blitSurface(icon, x, y);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();

			while (!done)
			{
				while (event.pollEvent() > 0)
				{
					switch (event.type)
					{
						case SDLEvent.SDL_MOUSEMOTION :
							// draw icon
							x = event.motion.x - w/2;
							y = event.motion.y - h/2;
							screen.blitSurface(icon, x, y);
							screen.updateRect();
							break;
						case SDLEvent.SDL_MOUSEBUTTONUP :
							// clear screen
							screen.fillRect(screen.mapRGB(Color.BLACK));
							screen.updateRect();
							break;
						case SDLEvent.SDL_KEYDOWN :
							if ((event.keydown.sym == Keyboard.SDLK_ESCAPE) ||
								(event.keydown.sym == Keyboard.SDLK_q))
								done = true;
							break;
						case SDLEvent.SDL_QUIT:
							done = true;
							break;
						default:
							break;
					}
				}

			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			Sys.quit();
		}
	}
}
