#include "sdl4gcj/mixer/Chunk.h"

#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <stdlib.h>
#include <string.h>
#include <SDL_mixer.h>


using namespace sdl4gcj::mixer;

// function
static
inline
sdl4gcj::SDLException*
createFreedChunkException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1("This Chunk was already freed."));
}

// class methods

Chunk*
Chunk::loadWAV(::java::lang::String * filePath)
{
	JvInitClass(&Chunk::class$);
	Chunk* result = NULL;

	jbyteArray byteArray = filePath->getBytes();
	int length = JvGetArrayLength(byteArray);
	jbyte* bytes = elements(byteArray);
	char buffer[length+1];

	memcpy(buffer, bytes, length);
	buffer[length] = '\0';

	Mix_Chunk* music = ::Mix_LoadWAV(buffer);
	if (music != NULL)
	{
		result = new Chunk();
		result->implementation = (::gnu::gcj::RawData*)music;
	}

	return result;
}

Chunk *
Chunk::loadWAV(JArray<jbyte>* byteArray, jint offset, jint length)
{
	JvInitClass(&Chunk::class$);
	Chunk* result = NULL;
	jbyte* bytes = elements(byteArray) + offset;

	Mix_Chunk* chunk = ::Mix_LoadWAV_RW(SDL_RWFromMem(bytes, length), 1);
	if (chunk != NULL)
	{
		result = new Chunk();
		result->implementation = (::gnu::gcj::RawData*)chunk;
	}

	return result;
}


// instance methods


void
Chunk::freeChunk()
{
	if (this->implementation != NULL) 
	{
		Mix_FreeChunk((Mix_Chunk *)this->implementation);
		this->implementation = NULL;
	}

	return ;
}

jint
Chunk::setVolume(jint volume)
{
	if (this->implementation == NULL) throw createFreedChunkException();
	Mix_Chunk* nativeChunk = (Mix_Chunk*)this->implementation;
	return ::Mix_VolumeChunk(nativeChunk, volume);
}

