/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.event;
import sdl4gcj.input.JoystickConstants;

public class JoyHatEvent extends SDLEvent implements JoystickConstants
{
	public short which;	/* The joystick device index */
	public short hat;	/* The joystick hat index */

	/* The hat position value:
	SDL_HAT_LEFTUP   SDL_HAT_UP       SDL_HAT_RIGHTUP
	SDL_HAT_LEFT     SDL_HAT_CENTERED SDL_HAT_RIGHT
	SDL_HAT_LEFTDOWN SDL_HAT_DOWN     SDL_HAT_RIGHTDOWN
	Note that zero means the POV is centered.
	*/
	public short value;	

	public JoyHatEvent()
	{
		this((short)0, (short)0, (short)0);
	}
	public JoyHatEvent(short which, short hat, short value)
	{
		super(SDL_JOYHATMOTION);
		this.which = which;
		this.hat = hat;
		this.value = value;
	}
}
