/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.input;

public interface KeyboardConstants
{
	int SDLK_UNKNOWN       = 0;
	int SDLK_FIRST         = 0;
	int SDLK_BACKSPACE     = 8;
	int SDLK_TAB           = 9;
	int SDLK_CLEAR         = 12;
	int SDLK_RETURN        = 13;
	int SDLK_PAUSE         = 19;
	int SDLK_ESCAPE        = 27;
	int SDLK_SPACE         = 32;
	int SDLK_EXCLAIM       = 33;
	int SDLK_QUOTEDBL      = 34;
	int SDLK_HASH          = 35;
	int SDLK_DOLLAR        = 36;
	int SDLK_AMPERSAND     = 38;
	int SDLK_QUOTE         = 39;
	int SDLK_LEFTPAREN     = 40;
	int SDLK_RIGHTPAREN    = 41;
	int SDLK_ASTERISK      = 42;
	int SDLK_PLUS          = 43;
	int SDLK_COMMA         = 44;
	int SDLK_MINUS         = 45;
	int SDLK_PERIOD        = 46;
	int SDLK_SLASH         = 47;
	int SDLK_0             = 48;
	int SDLK_1             = 49;
	int SDLK_2             = 50;
	int SDLK_3             = 51;
	int SDLK_4             = 52;
	int SDLK_5             = 53;
	int SDLK_6             = 54;
	int SDLK_7             = 55;
	int SDLK_8             = 56;
	int SDLK_9             = 57;
	int SDLK_COLON         = 58;
	int SDLK_SEMICOLON     = 59;
	int SDLK_LESS          = 60;
	int SDLK_EQUALS        = 61;
	int SDLK_GREATER       = 62;
	int SDLK_QUESTION      = 63;
	int SDLK_AT            = 64;

	/* 
	Skip uppercase letters
	*/
	int SDLK_LEFTBRACKET   = 91;
	int SDLK_BACKSLASH     = 92;
	int SDLK_RIGHTBRACKET  = 93;
	int SDLK_CARET         = 94;
	int SDLK_UNDERSCORE    = 95;
	int SDLK_BACKQUOTE     = 96;
	int SDLK_a             = 97;
	int SDLK_b             = 98;
	int SDLK_c             = 99;
	int SDLK_d             = 100;
	int SDLK_e             = 101;
	int SDLK_f             = 102;
	int SDLK_g             = 103;
	int SDLK_h             = 104;
	int SDLK_i             = 105;
	int SDLK_j             = 106;
	int SDLK_k             = 107;
	int SDLK_l             = 108;
	int SDLK_m             = 109;
	int SDLK_n             = 110;
	int SDLK_o             = 111;
	int SDLK_p             = 112;
	int SDLK_q             = 113;
	int SDLK_r             = 114;
	int SDLK_s             = 115;
	int SDLK_t             = 116;
	int SDLK_u             = 117;
	int SDLK_v             = 118;
	int SDLK_w             = 119;
	int SDLK_x             = 120;
	int SDLK_y             = 121;
	int SDLK_z             = 122;
	int SDLK_DELETE        = 127;
	/* End of ASCII mapped keysyms *

	/* International keyboard syms */
	int SDLK_WORLD_0       = 160; /* 0xA0 */
	int SDLK_WORLD_1       = 161;
	int SDLK_WORLD_2       = 162;
	int SDLK_WORLD_3       = 163;
	int SDLK_WORLD_4       = 164;
	int SDLK_WORLD_5       = 165;
	int SDLK_WORLD_6       = 166;
	int SDLK_WORLD_7       = 167;
	int SDLK_WORLD_8       = 168;
	int SDLK_WORLD_9       = 169;
	int SDLK_WORLD_10      = 170;
	int SDLK_WORLD_11      = 171;
	int SDLK_WORLD_12      = 172;
	int SDLK_WORLD_13      = 173;
	int SDLK_WORLD_14      = 174;
	int SDLK_WORLD_15      = 175;
	int SDLK_WORLD_16      = 176;
	int SDLK_WORLD_17      = 177;
	int SDLK_WORLD_18      = 178;
	int SDLK_WORLD_19      = 179;
	int SDLK_WORLD_20      = 180;
	int SDLK_WORLD_21      = 181;
	int SDLK_WORLD_22      = 182;
	int SDLK_WORLD_23      = 183;
	int SDLK_WORLD_24      = 184;
	int SDLK_WORLD_25      = 185;
	int SDLK_WORLD_26      = 186;
	int SDLK_WORLD_27      = 187;
	int SDLK_WORLD_28      = 188;
	int SDLK_WORLD_29      = 189;
	int SDLK_WORLD_30      = 190;
	int SDLK_WORLD_31      = 191;
	int SDLK_WORLD_32      = 192;
	int SDLK_WORLD_33      = 193;
	int SDLK_WORLD_34      = 194;
	int SDLK_WORLD_35      = 195;
	int SDLK_WORLD_36      = 196;
	int SDLK_WORLD_37      = 197;
	int SDLK_WORLD_38      = 198;
	int SDLK_WORLD_39      = 199;
	int SDLK_WORLD_40      = 200;
	int SDLK_WORLD_41      = 201;
	int SDLK_WORLD_42      = 202;
	int SDLK_WORLD_43      = 203;
	int SDLK_WORLD_44      = 204;
	int SDLK_WORLD_45      = 205;
	int SDLK_WORLD_46      = 206;
	int SDLK_WORLD_47      = 207;
	int SDLK_WORLD_48      = 208;
	int SDLK_WORLD_49      = 209;
	int SDLK_WORLD_50      = 210;
	int SDLK_WORLD_51      = 211;
	int SDLK_WORLD_52      = 212;
	int SDLK_WORLD_53      = 213;
	int SDLK_WORLD_54      = 214;
	int SDLK_WORLD_55      = 215;
	int SDLK_WORLD_56      = 216;
	int SDLK_WORLD_57      = 217;
	int SDLK_WORLD_58      = 218;
	int SDLK_WORLD_59      = 219;
	int SDLK_WORLD_60      = 220;
	int SDLK_WORLD_61      = 221;
	int SDLK_WORLD_62      = 222;
	int SDLK_WORLD_63      = 223;
	int SDLK_WORLD_64      = 224;
	int SDLK_WORLD_65      = 225;
	int SDLK_WORLD_66      = 226;
	int SDLK_WORLD_67      = 227;
	int SDLK_WORLD_68      = 228;
	int SDLK_WORLD_69      = 229;
	int SDLK_WORLD_70      = 230;
	int SDLK_WORLD_71      = 231;
	int SDLK_WORLD_72      = 232;
	int SDLK_WORLD_73      = 233;
	int SDLK_WORLD_74      = 234;
	int SDLK_WORLD_75      = 235;
	int SDLK_WORLD_76      = 236;
	int SDLK_WORLD_77      = 237;
	int SDLK_WORLD_78      = 238;
	int SDLK_WORLD_79      = 239;
	int SDLK_WORLD_80      = 240;
	int SDLK_WORLD_81      = 241;
	int SDLK_WORLD_82      = 242;
	int SDLK_WORLD_83      = 243;
	int SDLK_WORLD_84      = 244;
	int SDLK_WORLD_85      = 245;
	int SDLK_WORLD_86      = 246;
	int SDLK_WORLD_87      = 247;
	int SDLK_WORLD_88      = 248;
	int SDLK_WORLD_89      = 249;
	int SDLK_WORLD_90      = 250;
	int SDLK_WORLD_91      = 251;
	int SDLK_WORLD_92      = 252;
	int SDLK_WORLD_93      = 253;
	int SDLK_WORLD_94      = 254;
	int SDLK_WORLD_95      = 255; /* 0xFF */

	/* Numeric keypad */
	int SDLK_KP0           = 256;
	int SDLK_KP1           = 257;
	int SDLK_KP2           = 258;
	int SDLK_KP3           = 259;
	int SDLK_KP4           = 260;
	int SDLK_KP5           = 261;
	int SDLK_KP6           = 262;
	int SDLK_KP7           = 263;
	int SDLK_KP8           = 264;
	int SDLK_KP9           = 265;
	int SDLK_KP_PERIOD     = 266;
	int SDLK_KP_DIVIDE     = 267;
	int SDLK_KP_MULTIPLY   = 268;
	int SDLK_KP_MINUS      = 269;
	int SDLK_KP_PLUS       = 270;
	int SDLK_KP_ENTER      = 271;
	int SDLK_KP_EQUALS     = 272;

	/* Arrows + Home/End pad */
	int SDLK_UP            = 273;
	int SDLK_DOWN          = 274;
	int SDLK_RIGHT         = 275;
	int SDLK_LEFT          = 276;
	int SDLK_INSERT        = 277;
	int SDLK_HOME          = 278;
	int SDLK_END           = 279;
	int SDLK_PAGEUP        = 280;
	int SDLK_PAGEDOWN      = 281;

	/* Function keys */
	int SDLK_F1            = 282;
	int SDLK_F2            = 283;
	int SDLK_F3            = 284;
	int SDLK_F4            = 285;
	int SDLK_F5            = 286;
	int SDLK_F6            = 287;
	int SDLK_F7            = 288;
	int SDLK_F8            = 289;
	int SDLK_F9            = 290;
	int SDLK_F10           = 291;
	int SDLK_F11           = 292;
	int SDLK_F12           = 293;
	int SDLK_F13           = 294;
	int SDLK_F14           = 295;
	int SDLK_F15           = 296;

	/* Key state modifier keys */
	int SDLK_NUMLOCK       = 300;
	int SDLK_CAPSLOCK      = 301;
	int SDLK_SCROLLOCK     = 302;
	int SDLK_RSHIFT        = 303;
	int SDLK_LSHIFT        = 304;
	int SDLK_RCTRL         = 305;
	int SDLK_LCTRL         = 306;
	int SDLK_RALT          = 307;
	int SDLK_LALT          = 308;
	int SDLK_RMETA         = 309;
	int SDLK_LMETA         = 310;
	int SDLK_LSUPER        = 311; /* Left "Windows" key */
	int SDLK_RSUPER        = 312; /* Right "Windows" key */
	int SDLK_MODE          = 313; /* "Alt Gr" key */
	int SDLK_COMPOSE       = 314; /* Multi-key compose key */

	/* Miscellaneous function keys */
	int SDLK_HELP          = 315;
	int SDLK_PRINT         = 316;
	int SDLK_SYSREQ        = 317;
	int SDLK_BREAK         = 318;
	int SDLK_MENU          = 319;
	int SDLK_POWER         = 320; /* Power Macintosh power key */
	int SDLK_EURO          = 321; /* Some european keyboards */
	int SDLK_UNDO          = 322; /* Atari keyboard has Undo */

	/* Add any other keys here */
	int SDLK_LAST          = 323;

	/* Enumeration of valid key mods (possibly OR'd together) */
	int KMOD_NONE     = 0x0000;
	int KMOD_LSHIFT   = 0x0001;
	int KMOD_RSHIFT   = 0x0002;
	int KMOD_LCTRL    = 0x0040;
	int KMOD_RCTRL    = 0x0080;
	int KMOD_LALT     = 0x0100;
	int KMOD_RALT     = 0x0200;
	int KMOD_LMETA    = 0x0400;
	int KMOD_RMETA    = 0x0800;
	int KMOD_NUM      = 0x1000;
	int KMOD_CAPS     = 0x2000;
	int KMOD_MODE     = 0x4000;
	int KMOD_RESERVED = 0x8000;

	int KMOD_CTRL     = (KMOD_LCTRL|KMOD_RCTRL);
	int KMOD_SHIFT    = (KMOD_LSHIFT|KMOD_RSHIFT);
	int KMOD_ALT      = (KMOD_LALT|KMOD_RALT);
	int KMOD_META     = (KMOD_LMETA|KMOD_RMETA);
}
