/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.video;

public class Color
{
	public static final Color BLACK   = new Color(0x00, 0x00, 0x00);
	public static final Color WHITE   = new Color(0xFF, 0xFF, 0xFF);
	public static final Color RED     = new Color(0xFF, 0x00, 0x00);
	public static final Color GREEN   = new Color(0x00, 0xFF, 0x00);
	public static final Color BLUE    = new Color(0x00, 0x00, 0xFF);
	public static final Color CYAN    = new Color(0x00, 0xFF, 0xFF);
	public static final Color MAGENTA = new Color(0xFF, 0x00, 0xFF);
	public static final Color YELLOW  = new Color(0xFF, 0xFF, 0x00);

	public int r;
	public int g;
	public int b;
	public int a;

	public Color()
	{
		this(0, 0, 0, 0);
	}

	public Color(int red, int green, int blue)
	{
		this(red, green, blue, 0);
	}

	public Color(int red, int green, int blue, int alpha)
	{
		r = red;
		g = green;
		b = blue;
		a = alpha;
	}

	public String toString()
	{
		return super.toString() + " (" + r + ", " + g + ", " + b + ")";
	}
}

