/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/video/PixelFormat.h"
#include "sdl4gcj/video/Color.h"
#include "sdl4gcj/video/Palette.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <SDL.h>
#include <stdlib.h>

using namespace sdl4gcj::video;

// function
static
SDL_PixelFormat*
CloneFormat(SDL_PixelFormat *format)
{
	SDL_PixelFormat* cloneFormat = NULL;
	if (format)
	{
		cloneFormat = (SDL_PixelFormat*)JvMalloc(sizeof(SDL_PixelFormat));
		*cloneFormat = *format;
		if (format->palette)
		{
			int ncolors = format->palette->ncolors;
			cloneFormat->palette = (SDL_Palette*)JvMalloc(sizeof(SDL_Palette));
			cloneFormat->palette->ncolors = ncolors;
			if (format->palette->colors)
			{
				jint size = sizeof(SDL_Color) * ncolors;
				cloneFormat->palette->colors = (SDL_Color*)JvMalloc(size);
				memcpy(cloneFormat->palette->colors, format->palette->colors, size);
			}
		}
	}
	return cloneFormat;
}

static
void
FreeFormat(SDL_PixelFormat *format)
{
	if (format)
	{
		if (format->palette)
		{
			if (format->palette->colors)
			{
				JvFree(format->palette->colors);
			}
			JvFree(format->palette);
		}
		JvFree(format);
	}
}


static
inline
sdl4gcj::SDLException*
createInitializedFormatException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1("This Surface was already initialized."));
}

// instance variable
jbyte 
PixelFormat::getBitsPerPixel ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->BitsPerPixel;
	return result;
}

jbyte 
PixelFormat::getBytesPerPixel ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->BytesPerPixel;
	return result;
}

jbyte 
PixelFormat::getRloss ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Rloss;
	return result;
}

jbyte 
PixelFormat::getGloss ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Gloss;
	return result;
}

jbyte 
PixelFormat::getBloss ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Bloss;
	return result;
}

jbyte 
PixelFormat::getAloss ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Aloss;
	return result;
}

jbyte 
PixelFormat::getRshift ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Rshift;
	return result;
}

jbyte 
PixelFormat::getGshift ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Gshift;
	return result;
}

jbyte 
PixelFormat::getBshift ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Bshift;
	return result;
}

jbyte 
PixelFormat::getAshift ()
{
	jbyte result = 0;
	result = ((SDL_PixelFormat*)implementation)->Ashift;
	return result;
}

jint 
PixelFormat::getRmask ()
{
	jint result = 0;
	result = ((SDL_PixelFormat*)implementation)->Rmask;
	return result;
}

jint 
PixelFormat::getGmask ()
{
	jint result = 0;
	result = ((SDL_PixelFormat*)implementation)->Gmask;
	return result;
}

jint 
PixelFormat::getBmask ()
{
	jint result = 0;
	result = ((SDL_PixelFormat*)implementation)->Bmask;
	return result;
}

jint 
PixelFormat::getAmask ()
{
	jint result = 0;
	result = ((SDL_PixelFormat*)implementation)->Amask;
	return result;
}

jint 
PixelFormat::getColorkey ()
{
	jint result = 0;
	result = ((SDL_PixelFormat*)implementation)->colorkey;
	return result;
}

jint 
PixelFormat::getAlpha ()
{
	jint result = 0;
	result = ((SDL_PixelFormat*)implementation)->alpha;
	return result;
}

jint 
PixelFormat::mapRGB (jint red, jint green, jint blue)
{
	jint result = 0;
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;

	result = SDL_MapRGB(nativeFormat, red, green, blue);

	return result;
}

jint 
PixelFormat::mapRGBA (jint red, jint green, jint blue, jint alpha)
{
	jint result = 0;
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;

	result = SDL_MapRGBA(nativeFormat, red, green, blue, alpha);

	return result;
}

jintArray 
PixelFormat::getRGB (jint pixel)
{
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;
	jintArray result = JvNewIntArray(3);
	jint* rgb = elements(result);
	Uint8 r, g, b;

	SDL_GetRGB((Uint32)pixel, nativeFormat, &r, &g, &b);
	rgb[0] = r;
	rgb[1] = g;
	rgb[2] = b;

	return result;
}

Color* 
PixelFormat::getRGBColor (jint pixel)
{
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;
	Uint8 r, g, b;

	SDL_GetRGB((Uint32)pixel, nativeFormat, &r, &g, &b);
	Color* color = new Color(r, g, b);

	return color;
}

jintArray 
PixelFormat::getRGBA (jint pixel)
{
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;
	jintArray result = JvNewIntArray(4);
	jint* rgba = elements(result);
	Uint8 r, g, b, a;

	SDL_GetRGBA((Uint32)pixel, nativeFormat, &r, &g, &b, &a);
	rgba[0] = r;
	rgba[1] = g;
	rgba[2] = b;
	rgba[3] = a;

	return result;
}

Color* 
PixelFormat::getRGBAColor (jint pixel)
{
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;
	Uint8 r, g, b, a;

	SDL_GetRGBA((Uint32)pixel, nativeFormat, &r, &g, &b, &a);
	Color* color = new Color(r, g, b, a);

	return color;
}

Palette*
PixelFormat::getPalette ()
{
	SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;
	Palette* palette = NULL;

	if (nativeFormat->palette != NULL)
	{
		int ncolors = nativeFormat->palette->ncolors;
		SDL_Color* nativeColors = nativeFormat->palette->colors;

		palette = new Palette(ncolors);
		for (int i = 0;i < ncolors;i++)
		{
			palette->setColorAt(i, nativeColors[i].r, 
				nativeColors[i].g, nativeColors[i].b);
		}
	}

	return palette;
}

void
PixelFormat::initWithMask(jint depth,
		jint rmask, jint gmask, jint bmask, jint amask)
{
	if (this->implementation != NULL)
		throw createInitializedFormatException();

	SDL_Surface* tmpSurface;
	tmpSurface = SDL_CreateRGBSurface(SDL_SWSURFACE,
		1, 1, depth, rmask, gmask, bmask, amask);

	SDL_PixelFormat* nativeFormat = CloneFormat(tmpSurface->format);
	this->implementation = (::gnu::gcj::RawData*)nativeFormat;
	this->selfAllocated = true;

	SDL_FreeSurface(tmpSurface);
}

void
PixelFormat::freePixelFormat()
{
	if (this->selfAllocated && this->implementation != NULL)
	{
		SDL_PixelFormat* nativeFormat = (SDL_PixelFormat*)this->implementation;
		FreeFormat(nativeFormat);
		this->implementation = NULL;
	}
}

