import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class Test implements SDLConstants
{
	static final String SAVE_FILE = "saved.bmp";

	public static void main(String[] args)
	{
		SDLSystem.init(SDL_INIT_VIDEO);

		System.out.println(" Compiled SDL Version : " + SDLSystem.compiledVersion());
		System.out.println("   Linked SDL Version : " + SDLSystem.linkedVersion());

		PixelFormat format = new PixelFormat(32, 0xff0000, 0x00ff00, 0x0000ff, 0x00);
		System.out.println(" formt : " + format);

		Rect[] modes = Screen.listModes(null, SDL_SWSURFACE|SDL_FULLSCREEN);
		if (modes == null)
		{
			System.out.println("No resolusions available.");
		}
		else
		{
			if (modes.length == 0)
			{
				System.out.println("All resolusions available.");
			}
			else
			{
				System.out.println("Following resolusions available.");
				for (int i = 0;i < modes.length;i++)
				{
					System.out.println("(" + modes[i].getW() + ", " + modes[i].getH() + ")");
				}
			}
		}

		if (SDLSystem.byteOrder() == SDL_LIL_ENDIAN)
			System.out.println("SDLSystem.byteOrder() : SDL_LIL_ENDIAN = " + SDLSystem.byteOrder());
		else
			System.out.println("SDLSystem.byteOrder() : SDL_BIG_ENDIAN = " + SDLSystem.byteOrder());

		int bpp = Screen.videoModeOK(640, 480, 32, SDL_SWSURFACE);
		System.out.println("Screen.videoModeOK(640, 480, 32, SDL_SWSURFACE) : " + bpp);

		Screen.setCaption("Window Caption", "Icon Caption");
		System.out.println("windowCaption : '" + Screen.getWindowCaption() + "'");
		System.out.println("iconCaption   : '" + Screen.getIconCaption() + "'");
		Screen.setCaption(null, null); // no change
		System.out.println("windowCaption : '" + Screen.getWindowCaption() + "'");
		System.out.println("iconCaption   : '" + Screen.getIconCaption() + "'");
		Screen.setCaption("", ""); // remove caption
		System.out.println("windowCaption : '" + Screen.getWindowCaption() + "'");
		System.out.println("iconCaption   : '" + Screen.getIconCaption() + "'");

		Surface icon = Surface.loadBMP("images/icon.bmp");

		byte[] iconMask = new byte[32 * 4];
		for (int i = 0;i < iconMask.length;i++)
		{
			iconMask[i] = (byte)0x0f;
		}

		Screen.setIcon(icon, iconMask);

		try
		{
			Screen screen = Screen.setVideoMode(640, 480, bpp, SDL_SWSURFACE|SDL_ANYFORMAT);
			Surface memory = screen.cloneSurface();

			int bgPixel = screen.mapRGB(Color.BLACK);

			icon.setColorKey(SDL_SRCCOLORKEY|SDL_RLEACCEL);
			icon.displayFormat();

			ImageFont font = new ImageFont();

			int w = icon.getW();
			int h = icon.getH();
			int x = (screen.getW() - w) / 2;
			int y = (screen.getH() - h) / 2;

			screen.fillRect(bgPixel);
			font.draw(screen, "Push 's' key to save screen into memory", 0, 0);
			font.draw(screen, "Push 'l' key to load from memory", 0, 32);
			font.draw(screen, "Push 'c' key to clear screen.", 0, 64);
			font.draw(screen, "Push 'i' key to iconify window.", 0, 96);
			font.draw(screen, "Push 't' key to toggle fullscreen mode.", 0, 128);
			font.draw(screen, "Push 'g' key to grab input mode.", 0, 160);
			screen.updateRect();

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				event.waitEvent();
				switch (event.type)
				{
					case SDL_MOUSEMOTION :
						// draw icon
						if (Mouse.getMouse().getButtonState(SDL_BUTTON_LEFT))
						{
							x = event.motion.x - w/2;
							y = event.motion.y - h/2;
							screen.blitSurface(icon, x, y);
							screen.updateRect();
						}
						break;
					case SDL_KEYDOWN :
						if ((event.keydown.sym == SDLK_ESCAPE) ||
							(event.keydown.sym == SDLK_q))
						{
							done = true;
						}
						else if (event.keydown.sym == SDLK_s)
						{
							memory.freeSurface();
							memory = screen.cloneSurface();
							System.out.println("Screen is saved into memory.");
						}
						else if (event.keydown.sym == SDLK_l)
						{
							screen.blitSurface(memory);
							screen.updateRect();
							System.out.println("Screen is loaded from memory. ");
						}
						else if (event.keydown.sym == SDLK_c)
						{
							screen.fillRect(bgPixel);
							screen.updateRect();
						}
						else if (event.keydown.sym == SDLK_i)
						{
							screen.iconifyWindow();
							System.out.println("iconifyWindow()");
						}
						else if (event.keydown.sym == SDLK_t)
						{
							screen.toggleFullScreen();
							System.out.println("toggleFullScreen()");
						}
						else if (event.keydown.sym == SDLK_g)
						{
							boolean grabMode = screen.getGrabInputMode();
							System.out.println("grabInput()");
							System.out.println("Old grabMode : " + grabMode);
							grabMode = screen.grabInput(!grabMode);
							System.out.println("New grabMode : " + grabMode);
						}
						break;
					case SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
