package org.seasar.extension.jdbc;

import java.sql.DatabaseMetaData;

import org.seasar.framework.beans.PropertyNotFoundRuntimeException;

/**
 * @author higa
 *
 */
public interface BeanMetaData {
	
	public String TABLE_KEY = "TABLE";
	public String COLUMN_KEY_SUFFIX = "_COLUMN";
	public String RELNO_KEY_SUFFIX = "_RELNO";
	public String RELKEYS_KEY_SUFFIX = "_RELKEYS";

	public Class getBeanClass();

	public String getTableName();
	
	public int getPropertyTypeSize();
	
	public PropertyType getPropertyType(int index);
	
	public PropertyType getPropertyType(String propertyName)
		throws PropertyNotFoundRuntimeException;
	
	public PropertyType getPropertyTypeByColumnName(String columnName)
		throws ColumnNotFoundRuntimeException;
	
	public int getRelationPropertyTypeSize();
	
	public RelationPropertyType getRelationPropertyType(int index);
	
	public RelationPropertyType getRelationPropertyType(String propertyName)
		throws PropertyNotFoundRuntimeException;
	
	public boolean isPersistent();
	
	public void setupDatabaseMetaData(DatabaseMetaData dbMetaData);
	
	public int getPrimaryKeySize();
	
	public String getPrimaryKey(int index);
}
