package org.seasar.extension.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

import org.seasar.extension.jdbc.RelationPropertyType;
import org.seasar.framework.beans.PropertyDesc;

public class BeanResultSetHandler extends AbstractBeanResultSetHandler {

	public BeanResultSetHandler(Class beanClass) {
		super(beanClass);
	}

	/**
	 * @see org.seasar.extension.jdbc.ResultSetHandler#handle(java.sql.ResultSet)
	 */
	public Object handle(ResultSet resultSet) throws SQLException {
		if (resultSet.next()) {
			setupDatabaseMetaData(resultSet.getStatement().getConnection()
					.getMetaData());
			Set columnNames = createColumnNames(resultSet.getMetaData());
			Object row = createRow(resultSet, columnNames);
			for (int i = 0; i < getBeanMetaData().getRelationPropertyTypeSize(); ++i) {
				RelationPropertyType rpt = getBeanMetaData()
						.getRelationPropertyType(i);
				if (rpt == null) {
					continue;
				}
				Object relationRow = createRelationRow(resultSet, rpt,
						columnNames);
				if (relationRow != null) {
					PropertyDesc pd = rpt.getPropertyDesc();
					pd.setValue(row, relationRow);
				}
			}
			return row;
		} else {
			return null;
		}
	}
}