package org.seasar.framework.container.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ognl.OgnlRuntime;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.ognl.S2ContainerPropertyAccessor;

/**
 * @author higa
 *  
 */
public class S2ContainerImpl implements S2Container, ContainerConstants {

	private Map componentDefMap_ = new HashMap();
	private List componentDefList_ = new ArrayList();
	private String namespace_;
	private String path_;
	private S2Container rootContainer_;
	private List children_ = new ArrayList();
	private Set paths_ = new HashSet();

	static {
		OgnlRuntime.setPropertyAccessor(S2Container.class,
				new S2ContainerPropertyAccessor());
	}

	public S2ContainerImpl() {
		rootContainer_ = this;
		ComponentDef selfDef = new SimpleComponentDef(this, NAME);
		registerMap(NAME, selfDef);
		registerMap(S2Container.class, selfDef);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Object)
	 */
	public Object getComponent(Object componentKey) {
		return getComponentDef(componentKey).getComponent();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object)
	 */
	public void injectDependency(Object outerComponent) {
		injectDependency(outerComponent, outerComponent.getClass());
	}

	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object,
	 *      java.lang.Class)
	 */
	public void injectDependency(Object outerComponent, Class componentClass) {
		getComponentDef(componentClass).injectDependency(outerComponent);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object,
	 *      java.lang.String)
	 */
	public void injectDependency(Object outerComponent, String componentName) {
		getComponentDef(componentName).injectDependency(outerComponent);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Object)
	 */
	public void register(Object component) {
		register(new SimpleComponentDef(component));
	}

	public void register(Object component, String componentName) {
		register(new SimpleComponentDef(component, componentName));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class)
	 */
	public void register(Class componentClass) {
		register(new ComponentDefImpl(componentClass));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class,
	 *      java.lang.String)
	 */
	public void register(Class componentClass, String componentName) {
		register(new ComponentDefImpl(componentClass, componentName));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(org.seasar.framework.container.ComponentDef)
	 */
	public void register(ComponentDef componentDef) {
		register0(componentDef);
		componentDefList_.add(componentDef);
	}

	private void register0(ComponentDef componentDef) {
		if (componentDef.getContainer() == null) {
			componentDef.setContainer(this);
		}
		registerByClass(componentDef);
		registerByName(componentDef);
	}

	private void registerByClass(ComponentDef componentDef) {
		Class[] classes = getAssignableClasses(componentDef.getComponentClass());
		for (int i = 0; i < classes.length; ++i) {
			registerMap(classes[i], componentDef);
		}
	}

	private void registerByName(ComponentDef componentDef) {
		String componentName = componentDef.getComponentName();
		if (componentName != null) {
			registerMap(componentName, componentDef);
		}
	}

	private void registerMap(Object key, ComponentDef componentDef) {
		if (componentDefMap_.containsKey(key)) {
			processTooManyRegistration(key, componentDef);
		} else {
			componentDefMap_.put(key, componentDef);
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDefSize()
	 */
	public int getComponentDefSize() {
		return componentDefList_.size();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(int)
	 */
	public ComponentDef getComponentDef(int index) {
		return (ComponentDef) componentDefList_.get(index);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Object)
	 */
	public ComponentDef getComponentDef(Object key)
			throws ComponentNotFoundRuntimeException {

		ComponentDef cd = getComponentDef0(key);
		if (cd == null) {
			throw new ComponentNotFoundRuntimeException(key);
		}
		return cd;
	}

	private ComponentDef getComponentDef0(Object key) {
		if (key instanceof String) {
			String name = (String) key;
			ComponentDef cd = (ComponentDef) componentDefMap_.get(name);
			if (cd != null) {
				return cd;
			}
			int index = name.indexOf(NS_SEP);
			if (index > 0) {
				String ns = name.substring(0, index);
				if (rootContainer_.hasComponentDef(ns)) {
					S2Container child = (S2Container) rootContainer_
							.getComponent(ns);
					name = name.substring(index + 1);
					if (child.hasComponentDef(name)) {
						return child.getComponentDef(name);
					}
				}
			}
		} else {
			ComponentDef cd = (ComponentDef) componentDefMap_.get(key);
			if (cd != null) {
				return cd;
			}
		}
		if (rootContainer_ != this && rootContainer_.hasComponentDef(key)) {
			return rootContainer_.getComponentDef(key);
		}
		return null;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#hasComponentDef(java.lang.Object)
	 */
	public boolean hasComponentDef(Object componentKey) {
		ComponentDef componentDef = getComponentDef0(componentKey);
		return componentDef != null
				&& !(componentDef instanceof TooManyRegistrationComponentDef);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#include(org.seasar.framework.container.S2Container)
	 */
	public void include(S2Container child) {
		String path = child.getPath();
		if (path != null) {
			if (paths_.contains(path)) {
				return;
			} else {
				paths_.add(path);
			}
		}
		child.setRootContainer(this);
		children_.add(child);
		String ns = child.getNamespace();
		if (ns != null) {
			registerMap(ns, new S2ContainerComponentDef(child, ns));
		}
		for (int i = 0; i < child.getComponentDefSize(); ++i) {
			register(child.getComponentDef(i));
		}
		for (int i = 0; i < child.getChildSize(); ++i) {
			S2Container grandchild = child.getChild(i);
			path = grandchild.getPath();
			if (path != null) {
				if (paths_.contains(path)) {
					continue;
				} else {
					paths_.add(path);
				}
			}
			ns = grandchild.getNamespace();
			if (ns != null) {
				registerMap(ns, new S2ContainerComponentDef(grandchild, ns));
			}
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getChildSize()
	 */
	public int getChildSize() {
		return children_.size();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getChild(int)
	 */
	public S2Container getChild(int index) {
		return (S2Container) children_.get(index);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#init()
	 */
	public void init() {
		for (int i = 0; i < getComponentDefSize(); ++i) {
			getComponentDef(i).init();
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#destroy()
	 */
	public void destroy() {
		for (int i = getComponentDefSize() - 1; 0 <= i; --i) {
			try {
				getComponentDef(i).destroy();
			} catch (Throwable t) {
				t.printStackTrace();
			}

		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getNamespace()
	 */
	public String getNamespace() {
		return namespace_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#setNamespace(java.lang.String)
	 */
	public void setNamespace(String namespace) {
		componentDefMap_.remove(namespace_);
		namespace_ = namespace;
		componentDefMap_.put(namespace_, new SimpleComponentDef(this,
				namespace_));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getPath()
	 */
	public String getPath() {
		return path_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#setPath(java.lang.String)
	 */
	public void setPath(String path) {
		paths_.remove(path);
		path_ = path;
		paths_.add(path);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getRootContainer()
	 */
	public S2Container getRootContainer() {
		return rootContainer_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#setRootContainer(org.seasar.framework.container.S2Container)
	 */
	public void setRootContainer(S2Container rootContainer) {
		rootContainer_ = rootContainer;
		for (int i = 0; i < children_.size(); ++i) {
			S2Container child = (S2Container) children_.get(i);
			child.setRootContainer(rootContainer);
		}

	}

	private static Class[] getAssignableClasses(Class componentClass) {
		Set classes = new HashSet();
		for (Class clazz = componentClass; clazz != Object.class
				&& clazz != null; clazz = clazz.getSuperclass()) {
			
			addAssignableClasses(classes, clazz);
		}
		return (Class[]) classes.toArray(new Class[classes.size()]);
	}
	
	private static void addAssignableClasses(Set classes,
			Class clazz) {
		
		classes.add(clazz);
		Class[] interfaces = clazz.getInterfaces();
		for (int i = 0; i < interfaces.length; ++i) {
			addAssignableClasses(classes, interfaces[i]);
		}
	}

	private void processTooManyRegistration(Object key,
			ComponentDef componentDef) {

		ComponentDef cd = (ComponentDef) componentDefMap_.get(key);
		if (cd instanceof TooManyRegistrationComponentDef) {
			((TooManyRegistrationComponentDef) cd)
					.addComponentClass(componentDef.getComponentClass());
		} else {
			TooManyRegistrationComponentDef tmrcf = new TooManyRegistrationComponentDef(
					key);
			tmrcf.addComponentClass(cd.getComponentClass());
			tmrcf.addComponentClass(componentDef.getComponentClass());
			componentDefMap_.put(key, tmrcf);
		}
	}
}