package test.org.seasar.dao.command;

import org.seasar.dao.command.UpdateCommand;
import org.seasar.extension.unit.S2TestCase;

public class UpdateCommandTest extends S2TestCase {

	public UpdateCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		UpdateCommand cmd = new UpdateCommand();
		cmd.setSql("UPDATE emp SET ename = /*employee.ename*/'HOGE' WHERE empno = /*employee.empno*/1234");
		cmd.setArgNames(new String[]{"employee"});
		
		Employee emp = new Employee();
		emp.setEmpno(7788);
		emp.setEname("SCOTT");
		Integer count = (Integer) cmd.execute(getDataSource(), new Object[]{emp});
		assertEquals("1", new Integer(1), count);
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateCommandTest.class);
	}

}
