package org.seasar.framework.container;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * OR|[lg`ꂽR|[lg̃NX
 * KpłȂƂ̎sO
 */
public class ClassUnmatchRuntimeException extends SRuntimeException {

	private Class componentClass_;
	private Class outerComponentClass_;
	
	/**
	 * @param componentKey
	 */
	public ClassUnmatchRuntimeException(
		Class componentClass,
		Class outerComponentClass) {
		super("ESSR0069", new Object[] { componentClass.getName(),
			outerComponentClass.getName()});
		componentClass_ = componentClass;
		outerComponentClass_ = outerComponentClass;
	}
	
	public Class getComponentClass() {
		return componentClass_;
	}
	
	public Class getOuterComponentClass() {
		return outerComponentClass_;
	}
}