package org.seasar.framework.util;

import java.text.SimpleDateFormat;

public final class ShortConversionUtil {

	private ShortConversionUtil() {
	}

	public static Short toShort(Object o) {
		return toShort(o, null);
	}
	
	public static Short toShort(Object o, String pattern) {
		if (o == null) {
			return null;
		} else if (o instanceof Short) {
			return (Short) o;
		} else if (o instanceof Number) {
			return new Short(((Number) o).shortValue());
		} else if (o instanceof String) {
			return new Short((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return new Short(new SimpleDateFormat(pattern).format(o));
			} else {
				return new Short((short) ((java.util.Date) o).getTime());
			}
		} else {
			return new Short(o.toString());
		}
	}
	
	public static short toPrimitiveShort(Object o) {
		return toPrimitiveShort(o, null);
	}

	public static short toPrimitiveShort(Object o, String pattern) {
		if (o == null) {
			return 0;
		} else if (o instanceof Number) {
			return ((Number) o).shortValue();
		} else if (o instanceof String) {
			return Short.parseShort((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return Short.parseShort(new SimpleDateFormat(pattern).format(o));
			} else {
				return (short) ((java.util.Date) o).getTime();
			}
		} else {
			return Short.parseShort(o.toString());
		}
	}
}
