package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.seasar.dao.DaoMetaData;
import org.seasar.dao.Dbms;

/**
 * @author higa
 *  
 */
public class DaoMetaDataFactory {

	private static Map daoMetaDataCache_ = new HashMap();

	private DaoMetaDataFactory() {
	}

	public static DaoMetaData getDaoMetaData(Class daoClass, Dbms dbms,
			DataSource ds) {

		String key = daoClass.getName() + dbms.getSuffix();
		DaoMetaData dmd = (DaoMetaData) daoMetaDataCache_.get(key);
		if (dmd != null) {
			return dmd;
		}
		synchronized (DaoMetaDataFactory.class) {
			dmd = (DaoMetaData) daoMetaDataCache_.get(key);
			if (dmd != null) {
				return dmd;
			}
			dmd = new DaoMetaDataImpl(daoClass, dbms, ds);
			daoMetaDataCache_.put(key, dmd);
		}
		return dmd;
	}
}