package test.org.seasar.dao.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.seasar.dao.impl.BeanReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;

/**
 * @author higa
 *
 */
public class BeanReaderTest extends TestCase {
	
	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public BeanReaderTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(BeanReaderTest.class);
	}

	protected void tearDown() throws Exception {
	}

	public void testRead() throws Exception {
		Employee emp = new Employee();
		emp.setEmpno(7788);
		emp.setEname("SCOTT");
		emp.setDeptno(10);
		Department dept = new Department();
		dept.setDeptno(10);
		dept.setDname("HOGE");
		emp.setDepartment(dept);
		BeanReader reader = new BeanReader(Employee.class, emp);
		DataSet ds = reader.read();
		DataTable table = ds.getTable("EMP");
		DataRow row = table.getRow(0);
		assertEquals("1", new BigDecimal(7788), row.getValue("empno"));
		assertEquals("2", "SCOTT", row.getValue("ename"));
		assertEquals("3", new BigDecimal(10), row.getValue("deptno"));
		assertEquals("4", "HOGE", row.getValue("dname_0"));
		
		List rows = new ArrayList();
		rows.add(emp);
		BeanReader reader2 = new BeanReader(Employee.class, rows);
		DataSet ds2 = reader2.read();
		DataTable table2 = ds2.getTable("EMP");
		DataRow row2 = table2.getRow(0);
		assertEquals("1", new BigDecimal(7788), row2.getValue("empno"));
		assertEquals("2", "SCOTT", row2.getValue("ename"));
		assertEquals("3", new BigDecimal(10), row2.getValue("deptno"));
		assertEquals("4", "HOGE", row2.getValue("dname_0"));
	}	
}