package test.org.seasar.dao.impl;

import org.seasar.dao.UpdateFailureRuntimeException;
import org.seasar.dao.impl.BeanMetaDataFactory;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.extension.unit.S2TestCase;

public class UpdateAutoStaticCommandTest extends S2TestCase {

	public UpdateAutoStaticCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(
				BeanMetaDataFactory.getBeanMetaData(Employee.class));
		Employee emp = new Employee();
		emp.setEmpno(7788);
		emp.setEname("SCOTT");
		Integer count = (Integer) cmd.execute(getDataSource(),
				new Object[] { emp });
		assertEquals("1", new Integer(1), count);
	}
	
	public void testExecute2Tx() throws Exception {
		UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(
				BeanMetaDataFactory.getBeanMetaData(Department.class));
		Department dept = new Department();
		dept.setDeptno(10);
		Integer count = (Integer) cmd.execute(getDataSource(),
				new Object[] { dept });
		assertEquals("1", new Integer(1), count);
		assertEquals("2", 1, dept.getVersionNo());
	}
	
	public void testExecute3Tx() throws Exception {
		UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(
				BeanMetaDataFactory.getBeanMetaData(Department.class));
		Department dept = new Department();
		dept.setDeptno(10);
		dept.setVersionNo(-1);
		try {
			cmd.execute(getDataSource(), new Object[] { dept });
			fail("1");
		} catch (UpdateFailureRuntimeException ex) {
			System.out.println(ex);
		}
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateAutoStaticCommandTest.class);
	}

}