package org.seasar.struts;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ClassUtil;

/**
 * @author higa, kimura
 */
public final class ActionUtil {
    

    private ActionUtil() {
    }

    /**
     * @deprecated use createActionFromClassName(String)
     * @see #createActionWithClassName(String)
     */
    public static Action createAction(String className) {
        return createActionWithClassName(className);
    }

    public static Action createActionWithClassName(String className) {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Class clazz = ClassUtil.forName(className);
        if (false == container.hasComponentDef(clazz)) {
            container.register(clazz);
        }
        return (Action) container.getComponent(clazz);
    }

    public static Action createActionWithComponentName(String componentName) throws ComponentNotFoundRuntimeException {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        return (Action) container.getComponent(componentName);
    }

    public static Action processActionCreate(HttpServletRequest request, HttpServletResponse response,
            ActionMapping mapping, Log log, MessageResources internal, ActionServlet servlet) throws IOException {

        String className = mapping.getType();
        if (log.isDebugEnabled()) {
            log.debug(" Looking for Action instance for class " + className);
        }
        Action instance = null;
        try {
            instance = createActionWithClassName(className);
        } catch (Exception e) {
            String internalMessage = internal.getMessage("actionCreate", mapping.getPath());

            log.error(internalMessage, e);

            response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, internalMessage);

            return (null);
        }
        instance.setServlet(servlet);
        return (instance);
    }

}