package org.seasar.struts;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/**
 * @author Satoshi Kimura
 */
public class ComponentNameCreatorImplTest extends S2TestCase {
    public ComponentNameCreatorImplTest(String name) {
        super(name);
    }

    protected void setUp() {
        SingletonS2ContainerFactory.setConfigPath("app.dicon");
        SingletonS2ContainerFactory.init();
    }

    protected void tearDown() {
        SingletonS2ContainerFactory.destroy();
    }

    public void testCreateComponentName() {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        ActionMapping mapping = new ActionMapping();
        String moduleName = "/module";
        String path = "/path";
        setInfo(mapping, moduleName, path);
        String componentName = new ComponentNameCreatorImpl().createComponentName(container, mapping);
        assertEquals("/module/path", componentName);
    }

    public void testCreateComponentNameNoModuleInDicon() {
        SingletonS2ContainerFactory.setConfigPath("org/seasar/struts/ComponentNameCreatorImplOnlyPathTest.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();
        ActionMapping mapping = new ActionMapping();
        String moduleName = "/module";
        String path = "/path";
        setInfo(mapping, moduleName, path);
        container = SingletonS2ContainerFactory.getContainer();
        String componentName = new ComponentNameCreatorImpl().createComponentName(container, mapping);
        assertEquals("/path", componentName);
    }


    public void testCreateComponentNameOnluPath() {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        ActionMapping mapping = new ActionMapping();
        String moduleName = "";
        String path = "/path";
        setInfo(mapping, moduleName, path);
        String componentName = new ComponentNameCreatorImpl().createComponentName(container, mapping);
        assertEquals("/path", componentName);
    }

    private void setInfo(ActionMapping mapping, String moduleName, String path) {
        mapping.setModuleConfig(new ModuleConfigImpl(moduleName));
        mapping.setPath(path);
    }

}