/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.parse.SpecificationParser;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.resource.ContextResourceLocation;
import org.apache.tapestry.spec.ApplicationSpecification;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.util.DefaultResourceResolver;
import org.apache.tapestry.util.DelegatingPropertySource;
import org.apache.tapestry.util.ServletContextPropertySource;
import org.apache.tapestry.util.ServletPropertySource;
import org.apache.tapestry.util.SystemPropertiesPropertySource;
import org.apache.tapestry.util.exception.ExceptionAnalyzer;
import org.apache.tapestry.util.pool.Pool;
import org.apache.tapestry.util.xml.DocumentParseException;

public class ApplicationServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$ApplicationServlet == null ? (class$org$apache$tapestry$ApplicationServlet = ApplicationServlet.class$("org.apache.tapestry.ApplicationServlet")) : class$org$apache$tapestry$ApplicationServlet));
    private static final String APP_SPEC_PATH_PARAM = "org.apache.tapestry.application-specification";
    private static final String LOCALE_COOKIE_NAME = "org.apache.tapestry.locale";
    private Pool _enginePool = new Pool();
    private IApplicationSpecification _specification;
    private String _attributeName;
    private String _engineClassName;
    private IPropertySource _propertySource;
    private IResourceResolver _resolver;
    static /* synthetic */ Class class$org$apache$tapestry$ApplicationServlet;
    static /* synthetic */ Class class$org$apache$tapestry$engine$BaseEngine;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doService(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestContext context;
        block16: {
            block15: {
                context = null;
                try {
                    try {
                        context = this.createRequestContext(request, response);
                        IEngine engine = this.getEngine(context);
                        if (engine == null) {
                            throw new ServletException(Tapestry.getMessage("ApplicationServlet.could-not-locate-engine"));
                        }
                        boolean dirty = engine.service(context);
                        HttpSession session = context.getSession();
                        if (session != null) {
                            block14: {
                                try {
                                    boolean forceStore;
                                    boolean bl = forceStore = engine.isStateful() && session.getAttribute(this._attributeName) == null;
                                    if (forceStore || dirty) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("Storing " + engine + " into session as " + this._attributeName));
                                        }
                                        session.setAttribute(this._attributeName, (Object)engine);
                                    }
                                }
                                catch (IllegalStateException ex) {
                                    if (!LOG.isDebugEnabled()) break block14;
                                    LOG.debug((Object)"Session invalidated.");
                                }
                            }
                            Object var9_11 = null;
                            if (context == null) return;
                            context.cleanup();
                            return;
                        }
                        if (engine.isStateful()) {
                            LOG.error((Object)Tapestry.format("ApplicationServlet.engine-stateful-without-session", engine));
                            break block15;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Returning " + engine + " to pool."));
                        }
                        this._enginePool.store(engine.getLocale(), engine);
                        break block16;
                    }
                    catch (ServletException ex) {
                        this.log("ServletException", ex);
                        this.show((Exception)((Object)ex));
                        throw ex;
                    }
                    catch (IOException ex) {
                        this.log("IOException", ex);
                        this.show(ex);
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    if (context == null) throw throwable;
                    context.cleanup();
                    throw throwable;
                }
            }
            Object var9_12 = null;
            if (context == null) return;
            context.cleanup();
            return;
        }
        Object var9_13 = null;
        if (context == null) return;
        context.cleanup();
    }

    protected RequestContext createRequestContext(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new RequestContext(this, request, response);
    }

    protected void show(Exception ex) {
        System.err.println("\n\n**********************************************************\n\n");
        new ExceptionAnalyzer().reportException(ex, System.err);
        System.err.println("\n**********************************************************\n");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doService(request, response);
    }

    public IApplicationSpecification getApplicationSpecification() {
        return this._specification;
    }

    protected IEngine getEngine(RequestContext context) throws ServletException {
        Locale locale;
        IEngine engine = null;
        HttpSession session = context.getSession();
        if (session != null) {
            engine = (IEngine)session.getAttribute(this._attributeName);
            if (engine != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Retrieved " + engine + " from session " + session.getId() + "."));
                }
                return engine;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Session exists, but doesn't contain an engine.");
            }
        }
        if ((engine = (IEngine)this._enginePool.retrieve(locale = this.getLocaleFromRequest(context))) == null) {
            engine = this.createEngine(context);
            engine.setLocale(locale);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using pooled engine " + engine + " (from locale " + locale + ")."));
        }
        return engine;
    }

    protected Locale getLocaleFromRequest(RequestContext context) throws ServletException {
        Cookie cookie = context.getCookie(LOCALE_COOKIE_NAME);
        if (cookie != null) {
            return Tapestry.getLocale(cookie.getValue());
        }
        return context.getRequest().getLocale();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._resolver = this.createResourceResolver();
        this._specification = this.constructApplicationSpecification();
        this._attributeName = "org.apache.tapestry.engine:" + config.getServletName();
    }

    protected IResourceResolver createResourceResolver() throws ServletException {
        return new DefaultResourceResolver();
    }

    protected IApplicationSpecification constructApplicationSpecification() throws ServletException {
        IResourceLocation specLocation = this.getApplicationSpecificationLocation();
        if (specLocation == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Tapestry.getMessage("ApplicationServlet.no-application-specification"));
            }
            return this.constructStandinSpecification();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loading application specification from " + specLocation));
        }
        return this.parseApplicationSpecification(specLocation);
    }

    protected IResourceLocation getApplicationSpecificationLocation() throws ServletException {
        String path = this.getApplicationSpecificationPath();
        if (path != null) {
            return new ClasspathResourceLocation(this._resolver, path);
        }
        ServletContext context = this.getServletContext();
        String servletName = this.getServletName();
        String expectedName = servletName + ".application";
        ContextResourceLocation webInfLocation = new ContextResourceLocation(context, "/WEB-INF/");
        IResourceLocation webInfAppLocation = webInfLocation.getRelativeLocation(servletName + "/");
        IResourceLocation result = this.check(webInfAppLocation, expectedName);
        if (result != null) {
            return result;
        }
        return this.check(webInfLocation, expectedName);
    }

    private IResourceLocation check(IResourceLocation location, String name) {
        IResourceLocation result = location.getRelativeLocation(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking for existence of " + result));
        }
        if (result.getResourceURL() != null) {
            LOG.debug((Object)"Found.");
            return result;
        }
        return null;
    }

    protected IApplicationSpecification constructStandinSpecification() {
        ApplicationSpecification result = new ApplicationSpecification();
        ContextResourceLocation virtualLocation = new ContextResourceLocation(this.getServletContext(), "/WEB-INF/");
        result.setSpecificationLocation(virtualLocation);
        result.setName(this.getServletName());
        result.setResourceResolver(this._resolver);
        return result;
    }

    protected IApplicationSpecification parseApplicationSpecification(IResourceLocation location) throws ServletException {
        try {
            SpecificationParser parser = new SpecificationParser(this._resolver);
            return parser.parseApplicationSpecification(location);
        }
        catch (DocumentParseException ex) {
            this.show(ex);
            throw new ServletException(Tapestry.format("ApplicationServlet.could-not-parse-spec", location), (Throwable)ex);
        }
    }

    protected void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {}
    }

    protected String getApplicationSpecificationPath() throws ServletException {
        return this.getInitParameter(APP_SPEC_PATH_PARAM);
    }

    protected IEngine createEngine(RequestContext context) throws ServletException {
        try {
            String className = this.getEngineClassName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating engine from class " + className));
            }
            Class engineClass = this.getResourceResolver().findClass(className);
            IEngine result = (IEngine)engineClass.newInstance();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created engine " + result));
            }
            return result;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected String getEngineClassName() {
        if (this._engineClassName != null) {
            return this._engineClassName;
        }
        this._engineClassName = this._specification.getEngineClassName();
        if (this._engineClassName == null) {
            this._engineClassName = this.searchConfiguration("org.apache.tapestry.engine-class");
        }
        if (this._engineClassName == null) {
            this._engineClassName = (class$org$apache$tapestry$engine$BaseEngine == null ? (class$org$apache$tapestry$engine$BaseEngine = ApplicationServlet.class$("org.apache.tapestry.engine.BaseEngine")) : class$org$apache$tapestry$engine$BaseEngine).getName();
        }
        return this._engineClassName;
    }

    protected String searchConfiguration(String propertyName) {
        if (this._propertySource == null) {
            this._propertySource = this.createPropertySource();
        }
        return this._propertySource.getPropertyValue(propertyName);
    }

    protected IPropertySource createPropertySource() {
        DelegatingPropertySource result = new DelegatingPropertySource();
        result.addSource(new ServletPropertySource(this.getServletConfig()));
        result.addSource(new ServletContextPropertySource(this.getServletContext()));
        result.addSource(SystemPropertiesPropertySource.getInstance());
        return result;
    }

    public void writeLocaleCookie(Locale locale, IEngine engine, RequestContext cycle) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing locale cookie " + locale));
        }
        Cookie cookie = new Cookie(LOCALE_COOKIE_NAME, locale.toString());
        cookie.setPath(engine.getServletPath());
        cycle.addCookie(cookie);
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

