/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.callback;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.callback.ICallback;

public class ExternalCallback
implements ICallback {
    private String _pageName;
    private Object[] _parameters;

    public ExternalCallback(String pageName, Object[] parameters) {
        this._pageName = pageName;
        this._parameters = parameters;
    }

    public ExternalCallback(IExternalPage page, Object[] parameters) {
        this._pageName = page.getPageName();
        this._parameters = parameters;
    }

    public void performCallback(IRequestCycle cycle) {
        try {
            IExternalPage page = (IExternalPage)cycle.getPage(this._pageName);
            cycle.activate(page);
            page.activateExternalPage(this._parameters, cycle);
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ExternalCallback.page-not-compatible", this._pageName), ex);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ExternalCallback[");
        buffer.append(this._pageName);
        buffer.append('/');
        if (this._parameters != null) {
            String sep = " ";
            int i = 0;
            while (i < this._parameters.length) {
                buffer.append(sep);
                buffer.append(this._parameters[i]);
                sep = ", ";
                ++i;
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

