/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.EngineServiceLink;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.request.ResponseOutputStream;
import org.apache.tapestry.util.StringSplitter;
import org.apache.tapestry.util.io.DataSqueezer;

public abstract class AbstractService
implements IEngineService {
    protected ILink constructLink(IRequestCycle cycle, String serviceName, String[] serviceContext, Object[] parameters, boolean stateful) {
        DataSqueezer squeezer = cycle.getEngine().getDataSqueezer();
        String[] squeezed = null;
        try {
            squeezed = squeezer.squeeze(parameters);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(ex);
        }
        return new EngineServiceLink(cycle, serviceName, serviceContext, squeezed, stateful);
    }

    protected String[] getServiceContext(RequestContext context) {
        String service = context.getParameter("service");
        int slashx = service.indexOf(47);
        if (slashx < 0) {
            return null;
        }
        String serviceContext = service.substring(slashx + 1);
        return new StringSplitter('/').splitToArray(serviceContext);
    }

    protected Object[] getParameters(IRequestCycle cycle) {
        RequestContext context = cycle.getRequestContext();
        Object[] squeezed = context.getParameters("sp");
        if (Tapestry.size(squeezed) == 0) {
            return squeezed;
        }
        try {
            DataSqueezer squeezer = cycle.getEngine().getDataSqueezer();
            return squeezer.unsqueeze((String[])squeezed);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    public abstract String getName();

    public abstract void service(IEngineServiceView var1, IRequestCycle var2, ResponseOutputStream var3) throws ServletException, IOException;

    public abstract ILink getLink(IRequestCycle var1, IComponent var2, Object[] var3);
}

