/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Location;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.parse.BodyRule;
import org.apache.tapestry.parse.ConnectChildRule;
import org.apache.tapestry.parse.IDocumentRule;
import org.apache.tapestry.parse.InitializePropertyRule;
import org.apache.tapestry.parse.SetBooleanPropertyRule;
import org.apache.tapestry.parse.SetConvertedPropertyRule;
import org.apache.tapestry.parse.SetExtendedPropertyRule;
import org.apache.tapestry.parse.SetLimitedPropertiesRule;
import org.apache.tapestry.parse.ValidateRule;
import org.apache.tapestry.util.RegexpMatcher;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SpecificationDigester
extends Digester {
    private List _documentRules;
    private IResourceLocation _resourceLocation;
    private RegexpMatcher _matcher;
    private ILocation _lastLocation;
    private int _lastLine;
    private int _lastColumn;
    private boolean _firstElement = true;

    public void addDocumentRule(IDocumentRule rule) {
        if (this._documentRules == null) {
            this._documentRules = new ArrayList();
        }
        rule.setDigester(this);
        this._documentRules.add(rule);
    }

    public void addSetBooleanProperty(String pattern, String attributeName, String propertyName) {
        this.addRule(pattern, new SetBooleanPropertyRule(attributeName, propertyName));
    }

    public void addSetExtendedProperty(String pattern, String attributeName, String propertyName, boolean required) {
        this.addRule(pattern, new SetExtendedPropertyRule(attributeName, propertyName, required));
    }

    public void addValidate(String pattern, String attributeName, String valuePattern, String errorKey) {
        this.addRule(pattern, new ValidateRule(this.getMatcher(), attributeName, valuePattern, errorKey));
    }

    public void addSetConvertedProperty(String pattern, Map map, String attributeName, String propertyName) {
        this.addRule(pattern, new SetConvertedPropertyRule(map, attributeName, propertyName));
    }

    public void addConnectChild(String pattern, String methodName, String attributeName) {
        this.addRule(pattern, new ConnectChildRule(methodName, attributeName));
    }

    public void addInitializeProperty(String pattern, String propertyName, Object value) {
        this.addRule(pattern, new InitializePropertyRule(propertyName, value));
    }

    public void addSetLimitedProperties(String pattern, String attributeName, String propertyName) {
        this.addRule(pattern, new SetLimitedPropertiesRule(attributeName, propertyName));
    }

    public void addSetLimitedProperties(String pattern, String[] attributeNames, String[] propertyNames) {
        this.addRule(pattern, new SetLimitedPropertiesRule(attributeNames, propertyNames));
    }

    public void addBody(String pattern, String propertyName) {
        this.addRule(pattern, new BodyRule(propertyName));
    }

    public Locator getLocator() {
        return this.locator;
    }

    public ILocation getLocationTag() {
        int line = -1;
        int column = -1;
        if (this.locator != null) {
            line = this.locator.getLineNumber();
            column = this.locator.getColumnNumber();
        }
        if (this._lastLine != line || this._lastColumn != column) {
            this._lastLocation = null;
        }
        if (this._lastLocation == null) {
            this._lastLine = line;
            this._lastColumn = column;
            this._lastLocation = new Location(this._resourceLocation, line, column);
        }
        return this._lastLocation;
    }

    public IResourceLocation getResourceLocation() {
        return this._resourceLocation;
    }

    public void setResourceLocation(IResourceLocation resourceLocation) {
        this._resourceLocation = resourceLocation;
        this._lastLocation = null;
        this._lastLine = -1;
        this._lastColumn = -1;
    }

    public RegexpMatcher getMatcher() {
        if (this._matcher == null) {
            this._matcher = new RegexpMatcher();
        }
        return this._matcher;
    }

    public void endDocument() throws SAXException {
        int count = Tapestry.size(this._documentRules);
        int i = 0;
        while (i < count) {
            IDocumentRule rule = (IDocumentRule)this._documentRules.get(i);
            try {
                rule.endDocument();
            }
            catch (Exception ex) {
                throw this.createSAXException(ex);
            }
            ++i;
        }
        super.endDocument();
        int i2 = 0;
        while (i2 < count) {
            IDocumentRule rule = (IDocumentRule)this._documentRules.get(i2);
            try {
                rule.finish();
            }
            catch (Exception ex) {
                throw this.createSAXException(ex);
            }
            ++i2;
        }
    }

    public void startDocument() throws SAXException {
        this._firstElement = true;
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._firstElement) {
            this.sendStartDocumentNotification(namespaceURI, localName, qName, attributes);
            this._firstElement = false;
        }
        super.startElement(namespaceURI, localName, qName, attributes);
    }

    private void sendStartDocumentNotification(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        int count = Tapestry.size(this._documentRules);
        String name = Tapestry.isBlank(localName) ? qName : localName;
        int i = 0;
        while (i < count) {
            IDocumentRule rule = (IDocumentRule)this._documentRules.get(i);
            try {
                rule.startDocument(namespaceURI, name, attributes);
            }
            catch (Exception ex) {
                throw this.createSAXException(ex);
            }
            ++i;
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        this.fatalError(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.fatalError(exception);
    }
}

