/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.util.Collection;
import java.util.Iterator;
import ognl.ClassResolver;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.event.ObservedChangeEvent;
import org.apache.tapestry.record.PageChange;
import org.apache.tapestry.util.prop.OgnlUtils;

public abstract class PageRecorder
implements IPageRecorder {
    private boolean _dirty = false;
    private boolean _locked = false;
    private boolean _discard = false;

    public abstract void commit();

    public abstract Collection getChanges();

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void setLocked(boolean value) {
        this._locked = value;
    }

    public void observeChange(ObservedChangeEvent event) {
        IComponent component = event.getComponent();
        String propertyName = event.getPropertyName();
        if (this._locked) {
            throw new ApplicationRuntimeException(Tapestry.format("PageRecorder.change-after-lock", component.getPage().getPageName(), propertyName, component.getExtendedId()));
        }
        if (propertyName == null) {
            throw new ApplicationRuntimeException(Tapestry.format("PageRecorder.null-property-name", component.getExtendedId()));
        }
        Object activeValue = event.getNewValue();
        try {
            this.recordChange(component.getIdPath(), propertyName, activeValue);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ApplicationRuntimeException(Tapestry.format("PageRecorder.unable-to-persist", propertyName, component.getExtendedId(), activeValue), t);
        }
    }

    protected abstract void recordChange(String var1, String var2, Object var3);

    public void rollback(IPage page) {
        Collection changes = this.getChanges();
        if (changes.isEmpty()) {
            return;
        }
        IResourceResolver resolver = page.getEngine().getResourceResolver();
        Iterator i = changes.iterator();
        while (i.hasNext()) {
            PageChange change = (PageChange)i.next();
            String propertyName = change.getPropertyName();
            IComponent component = page.getNestedComponent(change.getComponentPath());
            Object storedValue = change.getNewValue();
            try {
                OgnlUtils.set(propertyName, (ClassResolver)resolver, (Object)component, storedValue);
            }
            catch (Throwable t) {
                throw new ApplicationRuntimeException(Tapestry.format("PageRecorder.unable-to-rollback", new Object[]{propertyName, component, storedValue, t.getMessage()}), t);
            }
        }
    }

    public boolean isMarkedForDiscard() {
        return this._discard;
    }

    public void markForDiscard() {
        this._discard = true;
    }

    protected void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    protected boolean getDirty() {
        return this._dirty;
    }

    public abstract boolean getHasChanges();

    public abstract void discard();

    public abstract void initialize(String var1, IRequestCycle var2);
}

