/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resource;

import java.net.URL;
import java.util.Locale;
import org.apache.tapestry.IResourceLocation;

public abstract class AbstractResourceLocation
implements IResourceLocation {
    private String _path;
    private String _name;
    private String _folderPath;
    private Locale _locale;

    protected AbstractResourceLocation(String path) {
        this(path, null);
    }

    protected AbstractResourceLocation(String path, Locale locale) {
        this._path = path;
        this._locale = locale;
    }

    public String getName() {
        if (this._name == null) {
            this.split();
        }
        return this._name;
    }

    public IResourceLocation getRelativeLocation(String name) {
        if (name.startsWith("/")) {
            if (name.equals(this._path)) {
                return this;
            }
            return this.buildNewResourceLocation(name);
        }
        if (this._folderPath == null) {
            this.split();
        }
        if (name.equals(this._name)) {
            return this;
        }
        return this.buildNewResourceLocation(this._folderPath + name);
    }

    public String getPath() {
        return this._path;
    }

    public Locale getLocale() {
        return this._locale;
    }

    protected abstract IResourceLocation buildNewResourceLocation(String var1);

    private void split() {
        int lastSlashx = this._path.lastIndexOf(47);
        this._folderPath = this._path.substring(0, lastSlashx + 1);
        this._name = this._path.substring(lastSlashx + 1);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AbstractResourceLocation otherLocation = (AbstractResourceLocation)obj;
            return this._path.equals(otherLocation._path);
        }
        return false;
    }

    public abstract IResourceLocation getLocalization(Locale var1);

    public abstract URL getResourceURL();
}

