/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap
extends AbstractMap
implements Map,
Cloneable,
Externalizable {
    static final long serialVersionUID = 1L;
    private static final int INITIAL_CAPACITY = 17;
    private static final float LOAD_FACTOR = 0.75f;
    private transient int threshold_;
    private transient Entry[] mapTable_;
    private transient Entry[] listTable_;
    private transient int size_ = 0;
    private transient Set entrySet_ = null;

    public ArrayMap() {
        this(17);
    }

    public ArrayMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 17;
        }
        this.mapTable_ = new Entry[initialCapacity];
        this.listTable_ = new Entry[initialCapacity];
        this.threshold_ = (int)((float)initialCapacity * 0.75f);
    }

    public ArrayMap(Map map) {
        this((int)((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    public final int size() {
        return this.size_;
    }

    public final boolean isEmpty() {
        return this.size_ == 0;
    }

    public final boolean containsValue(Object value) {
        return this.indexOf(value) >= 0;
    }

    public final int indexOf(Object value) {
        if (value != null) {
            int i = 0;
            while (i < this.size_) {
                if (value.equals(this.listTable_[i].value_)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size_) {
                if (this.listTable_[i].value_ == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        Entry[] mapTable = this.mapTable_;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % mapTable.length;
            Entry e = mapTable[index];
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    return true;
                }
                e = e.next_;
            }
        } else {
            Entry e = mapTable[0];
            while (e != null) {
                if (e.key_ == null) {
                    return true;
                }
                e = e.next_;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry[] mapTable = this.mapTable_;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % mapTable.length;
            Entry e = mapTable[index];
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    return e.value_;
                }
                e = e.next_;
            }
        } else {
            Entry e = mapTable[0];
            while (e != null) {
                if (e.key_ == null) {
                    return e.value_;
                }
                e = e.next_;
            }
        }
        return null;
    }

    public final Object get(int index) {
        return this.getEntry((int)index).value_;
    }

    public final Object getKey(int index) {
        return this.getEntry((int)index).key_;
    }

    public final Entry getEntry(int index) {
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException("Index:" + index + ", Size:" + this.size_);
        }
        return this.listTable_[index];
    }

    public Object put(Object key, Object value) {
        Entry e;
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable_.length;
            e = this.mapTable_[index];
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    return this.swapValue(e, value);
                }
                e = e.next_;
            }
        } else {
            e = this.mapTable_[0];
            while (e != null) {
                if (e.key_ == null) {
                    return this.swapValue(e, value);
                }
                e = e.next_;
            }
        }
        this.ensureCapacity();
        index = (hashCode & Integer.MAX_VALUE) % this.mapTable_.length;
        this.mapTable_[index] = e = new Entry(hashCode, key, value, this.mapTable_[index]);
        this.listTable_[this.size_++] = e;
        return null;
    }

    public final void set(int index, Object value) {
        this.getEntry(index).setValue(value);
    }

    public Object remove(Object key) {
        Entry e = this.removeMap(key);
        if (e != null) {
            Object value = e.value_;
            this.removeList(this.indexOf(e));
            e.clear();
            return value;
        }
        return null;
    }

    public final Object remove(int index) {
        Entry e = this.removeList(index);
        Object value = e.value_;
        this.removeMap(e.key_);
        e.value_ = null;
        return value;
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public final void clear() {
        int i = 0;
        while (i < this.mapTable_.length) {
            this.mapTable_[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.listTable_.length) {
            this.listTable_[i] = null;
            ++i;
        }
        this.size_ = 0;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this.size_];
        int i = 0;
        while (i < array.length) {
            array[i] = this.get(i);
            ++i;
        }
        return array;
    }

    public final Object[] toArray(Object[] proto) {
        Object[] array = proto;
        if (proto.length < this.size_) {
            array = (Object[])Array.newInstance(proto.getClass().getComponentType(), this.size_);
        }
        int i = 0;
        while (i < array.length) {
            array[i] = this.get(i);
            ++i;
        }
        if (array.length > this.size_) {
            array[this.size_] = null;
        }
        return array;
    }

    public final boolean equals(Object o) {
        if (!this.getClass().isInstance(o)) {
            return false;
        }
        ArrayMap e = (ArrayMap)o;
        if (this.size_ != e.size_) {
            return false;
        }
        int i = 0;
        while (i < this.size_) {
            if (!this.listTable_[i].equals(e.listTable_[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final Set entrySet() {
        if (this.entrySet_ == null) {
            this.entrySet_ = new AbstractSet(){

                public Iterator iterator() {
                    return new ArrayMapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    int index = (entry.hashCode_ & Integer.MAX_VALUE) % ArrayMap.this.mapTable_.length;
                    Entry e = ArrayMap.this.mapTable_[index];
                    while (e != null) {
                        if (e.equals(entry)) {
                            return true;
                        }
                        e = e.next_;
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    return ArrayMap.this.remove(entry.key_) != null;
                }

                public int size() {
                    return ArrayMap.this.size_;
                }

                public void clear() {
                    ArrayMap.this.clear();
                }
            };
        }
        return this.entrySet_;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.listTable_.length);
        out.writeInt(this.size_);
        int i = 0;
        while (i < this.size_) {
            out.writeObject(this.listTable_[i].key_);
            out.writeObject(this.listTable_[i].value_);
            ++i;
        }
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this.mapTable_ = new Entry[num];
        this.listTable_ = new Entry[num];
        this.threshold_ = (int)((float)num * 0.75f);
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
            ++i;
        }
    }

    public Object clone() {
        ArrayMap copy = new ArrayMap();
        copy.threshold_ = this.threshold_;
        copy.mapTable_ = this.mapTable_;
        copy.listTable_ = this.listTable_;
        copy.size_ = this.size_;
        return copy;
    }

    private final int indexOf(Entry entry) {
        int i = 0;
        while (i < this.size_) {
            if (this.listTable_[i] == entry) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final void addList(int index, Entry entry) {
        this.checkHighRange(index);
        System.arraycopy(this.listTable_, index, this.listTable_, index + 1, this.size_ - index);
        this.listTable_[index] = entry;
        ++this.size_;
    }

    private final Entry removeMap(Object key) {
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable_.length;
            Entry e = this.mapTable_[index];
            Entry prev = null;
            while (e != null) {
                if (e.hashCode_ == hashCode && key.equals(e.key_)) {
                    if (prev != null) {
                        prev.next_ = e.next_;
                    } else {
                        this.mapTable_[index] = e.next_;
                    }
                    return e;
                }
                prev = e;
                e = e.next_;
            }
        } else {
            Entry e = this.mapTable_[index];
            Entry prev = null;
            while (e != null) {
                if (e.hashCode_ == hashCode && e.key_ == null) {
                    if (prev != null) {
                        prev.next_ = e.next_;
                    } else {
                        this.mapTable_[index] = e.next_;
                    }
                    return e;
                }
                prev = e;
                e = e.next_;
            }
        }
        return null;
    }

    private final Entry removeList(int index) {
        Entry e = this.listTable_[index];
        int numMoved = this.size_ - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.listTable_, index + 1, this.listTable_, index, numMoved);
        }
        this.listTable_[--this.size_] = null;
        return e;
    }

    private final void ensureCapacity() {
        if (this.size_ >= this.threshold_) {
            Entry[] oldTable = this.listTable_;
            int newCapacity = oldTable.length * 2 + 1;
            Entry[] newMapTable = new Entry[newCapacity];
            Entry[] newListTable = new Entry[newCapacity];
            this.threshold_ = (int)((float)newCapacity * 0.75f);
            System.arraycopy(oldTable, 0, newListTable, 0, this.size_);
            int i = 0;
            while (i < this.size_) {
                Entry old = oldTable[i];
                int index = (old.hashCode_ & Integer.MAX_VALUE) % newCapacity;
                Entry e = old;
                old = old.next_;
                e.next_ = newMapTable[index];
                newMapTable[index] = e;
                ++i;
            }
            this.mapTable_ = newMapTable;
            this.listTable_ = newListTable;
        }
    }

    private final Object swapValue(Entry entry, Object value) {
        Object old = entry.value_;
        entry.value_ = value;
        return old;
    }

    private final Object swapValue(int index, Entry entry, Object value) {
        Object old = this.swapValue(entry, value);
        this.removeList(this.indexOf(entry));
        this.addList(index, entry);
        return old;
    }

    private final void checkHighRange(int index) {
        if (index > this.size_) {
            throw new ArrayIndexOutOfBoundsException("index:" + index);
        }
    }

    private class ArrayMapIterator
    implements Iterator {
        private int current_ = 0;
        private int last_ = -1;

        ArrayMapIterator() {
        }

        public boolean hasNext() {
            return this.current_ != ArrayMap.this.size_;
        }

        public Object next() {
            try {
                Entry n = ArrayMap.this.listTable_[this.current_];
                this.last_ = this.current_++;
                return n;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.last_ == -1) {
                throw new IllegalStateException();
            }
            ArrayMap.this.remove(this.last_);
            if (this.last_ < this.current_) {
                --this.current_;
            }
            this.last_ = -1;
        }
    }

    private static class Entry
    implements Map.Entry,
    Externalizable {
        transient int hashCode_;
        transient Object key_;
        transient Object value_;
        transient Entry next_;

        public Entry(int hashCode, Object key, Object value, Entry next) {
            this.hashCode_ = hashCode;
            this.key_ = key;
            this.value_ = value;
            this.next_ = next;
        }

        public Object getKey() {
            return this.key_;
        }

        public Object getValue() {
            return this.value_;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value_;
            this.value_ = value;
            return oldValue;
        }

        public void clear() {
            this.key_ = null;
            this.value_ = null;
            this.next_ = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Entry e = (Entry)o;
            return (this.key_ != null ? this.key_.equals(e.key_) : e.key_ == null) && (this.value_ != null ? this.value_.equals(e.value_) : e.value_ == null);
        }

        public int hashCode() {
            return this.hashCode_;
        }

        public String toString() {
            return this.key_ + "=" + this.value_;
        }

        public void writeExternal(ObjectOutput s) throws IOException {
            s.writeInt(this.hashCode_);
            s.writeObject(this.key_);
            s.writeObject(this.value_);
            s.writeObject(this.next_);
        }

        public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
            this.hashCode_ = s.readInt();
            this.key_ = s.readObject();
            this.value_ = s.readObject();
            this.next_ = (Entry)s.readObject();
        }
    }
}

