/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPoolTail;
import javassist.CtArray;
import javassist.CtClass;
import javassist.CtClassType;
import javassist.CtMethod;
import javassist.CtNewClass;
import javassist.NotFoundException;
import javassist.Translator;

public class ClassPool {
    protected ClassPool source;
    protected Translator translator;
    protected Hashtable classes;
    private static ClassPool defaultPool = null;
    private Hashtable cflow = null;
    private static LocalClassLoader classLoader = new LocalClassLoader();

    protected CtClass getCached(String classname) {
        return (CtClass)this.classes.get(classname);
    }

    protected void removeCached(String classname) {
        this.classes.remove(classname);
    }

    public ClassPool(ClassPool src) {
        this(src, null);
    }

    public ClassPool(ClassPool src, Translator trans) throws RuntimeException {
        this.classes = new Hashtable();
        CtClass[] pt = CtClass.primitiveTypes;
        int i = 0;
        while (i < pt.length) {
            this.classes.put(pt[i].getName(), pt[i]);
            ++i;
        }
        this.source = src != null ? src : new ClassPoolTail();
        this.translator = trans;
        if (trans != null) {
            try {
                trans.start(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Translator.start() throws an exception: " + e.toString());
            }
        }
    }

    protected ClassPool() {
        this.source = null;
        this.classes = null;
        this.translator = null;
    }

    public static synchronized ClassPool getDefault(Translator t) {
        if (defaultPool == null) {
            ClassPoolTail tail = new ClassPoolTail();
            tail.appendSystemPath();
            defaultPool = new ClassPool(tail, t);
        }
        return defaultPool;
    }

    public static ClassPool getDefault() {
        return ClassPool.getDefault(null);
    }

    public String toString() {
        return this.source.toString();
    }

    public Translator getTranslator() {
        return this.translator;
    }

    void recordCflow(String name, String cname, String fname) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        this.cflow.put(name, new Object[]{cname, fname});
    }

    public Object[] lookupCflow(String name) {
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        return (Object[])this.cflow.get(name);
    }

    public void debugWriteFile(String classname) throws NotFoundException, CannotCompileException, IOException {
        this.debugWriteFile(classname, ".");
    }

    public void debugWriteFile(String classname, String directoryName) throws NotFoundException, CannotCompileException, IOException {
        this.writeFile(classname, directoryName, false);
    }

    public void writeFile(String classname) throws NotFoundException, CannotCompileException, IOException {
        this.writeFile(classname, ".");
    }

    public void writeFile(String classname, String directoryName) throws NotFoundException, CannotCompileException, IOException {
        this.writeFile(classname, directoryName, true);
    }

    private void writeFile(String classname, String directoryName, boolean callback) throws NotFoundException, CannotCompileException, IOException {
        String dir;
        String filename = directoryName + File.separatorChar + classname.replace('.', File.separatorChar) + ".class";
        int pos = filename.lastIndexOf(File.separatorChar);
        if (pos > 0 && !(dir = filename.substring(0, pos)).equals(".")) {
            new File(dir).mkdirs();
        }
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new DelayedFileOutputStream(filename)));
        this.write(classname, out, callback);
        out.close();
    }

    public static Class forName(String name) throws ClassNotFoundException {
        return classLoader.loadClass(name);
    }

    public Class writeAsClass(String classname) throws NotFoundException, IOException, CannotCompileException {
        try {
            return classLoader.loadClass(classname, this.write(classname));
        }
        catch (ClassFormatError e) {
            throw new CannotCompileException(e, classname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(String classname) throws NotFoundException, IOException, CannotCompileException {
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(barray);
        try {
            this.write(classname, out, true);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            out.close();
            throw throwable;
        }
        out.close();
        return barray.toByteArray();
    }

    public void write(String classname, DataOutputStream out) throws NotFoundException, CannotCompileException, IOException {
        this.write(classname, out, true);
    }

    private void write(String classname, DataOutputStream out, boolean callback) throws NotFoundException, CannotCompileException, IOException {
        CtClass clazz = this.getCached(classname);
        if (callback && this.translator != null && (clazz == null || !clazz.isFrozen())) {
            this.translator.onWrite(this, classname);
            clazz = this.getCached(classname);
        }
        if (clazz == null || !clazz.isModified()) {
            if (clazz != null) {
                clazz.freeze();
            }
            this.source.write(classname, out);
        } else {
            clazz.toBytecode(out);
        }
    }

    byte[] readSource(String classname) throws NotFoundException, IOException, CannotCompileException {
        return this.source.write(classname);
    }

    synchronized void classNameChanged(String oldname, CtClass clazz) {
        CtClass c = this.getCached(oldname);
        if (c == clazz) {
            this.removeCached(oldname);
        }
        String newName = clazz.getName();
        this.checkNotFrozen(newName, "the class with the new name is frozen.");
        this.classes.put(newName, clazz);
    }

    void checkNotFrozen(String classname, String errmsg) throws RuntimeException {
        CtClass c = (CtClass)this.classes.get(classname);
        if (c != null && c.isFrozen()) {
            throw new RuntimeException(errmsg);
        }
    }

    public CtClass getAndRename(String orgName, String newName) throws NotFoundException {
        CtClass clazz = this.get0(orgName);
        clazz.setName(newName);
        return clazz;
    }

    public synchronized CtClass get(String classname) throws NotFoundException {
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (clazz == null) {
            clazz = this.get0(classname);
            this.classes.put(classname, clazz);
        }
        return clazz;
    }

    protected CtClass get0(String classname) throws NotFoundException {
        if (classname.endsWith("[]")) {
            return new CtArray(classname, this);
        }
        this.checkClassName(classname);
        return new CtClassType(classname, this);
    }

    public CtClass[] get(String[] classnames) throws NotFoundException {
        if (classnames == null) {
            return new CtClass[0];
        }
        int num = classnames.length;
        CtClass[] result = new CtClass[num];
        int i = 0;
        while (i < num) {
            result[i] = this.get(classnames[i]);
            ++i;
        }
        return result;
    }

    public CtMethod getMethod(String classname, String methodname) throws NotFoundException {
        CtClass c = this.get(classname);
        return c.getDeclaredMethod(methodname);
    }

    public CtClass makeClass(InputStream classfile) throws IOException, RuntimeException {
        CtClassType clazz = new CtClassType(classfile, this);
        ((CtClass)clazz).checkModify();
        String classname = clazz.getName();
        this.checkNotFrozen(classname, "there is a frozen class with the same name.");
        this.classes.put(classname, clazz);
        return clazz;
    }

    public CtClass makeClass(String classname) throws RuntimeException {
        return this.makeClass(classname, null);
    }

    public synchronized CtClass makeClass(String classname, CtClass superclass) throws RuntimeException {
        this.checkNotFrozen(classname, "the class with the given name is frozen.");
        CtNewClass clazz = new CtNewClass(classname, this, false, superclass);
        this.classes.put(classname, clazz);
        return clazz;
    }

    public CtClass makeInterface(String name) throws RuntimeException {
        return this.makeInterface(name, null);
    }

    public synchronized CtClass makeInterface(String name, CtClass superclass) throws RuntimeException {
        this.checkNotFrozen(name, "the interface with the given name is frozen.");
        CtNewClass clazz = new CtNewClass(name, this, true, superclass);
        this.classes.put(name, clazz);
        return clazz;
    }

    void checkClassName(String classname) throws NotFoundException {
        this.source.checkClassName(classname);
    }

    public ClassPath appendSystemPath() {
        return this.source.appendSystemPath();
    }

    public ClassPath insertClassPath(ClassPath cp) {
        return this.source.insertClassPath(cp);
    }

    public ClassPath appendClassPath(ClassPath cp) {
        return this.source.appendClassPath(cp);
    }

    public ClassPath insertClassPath(String pathname) throws NotFoundException {
        return this.source.insertClassPath(pathname);
    }

    public ClassPath appendClassPath(String pathname) throws NotFoundException {
        return this.source.appendClassPath(pathname);
    }

    public synchronized void removeClassPath(ClassPath cp) {
        this.source.removeClassPath(cp);
    }

    public void appendPathList(String pathlist) throws NotFoundException {
        char sep = File.pathSeparatorChar;
        int i = 0;
        while (true) {
            int j;
            if ((j = pathlist.indexOf(sep, i)) < 0) break;
            this.appendClassPath(pathlist.substring(i, j));
            i = j + 1;
        }
        this.appendClassPath(pathlist.substring(i));
    }

    static class LocalClassLoader
    extends ClassLoader {
        LocalClassLoader() {
        }

        public Class loadClass(String name, byte[] classfile) throws ClassFormatError {
            Class<?> c = this.defineClass(name, classfile, 0, classfile.length);
            this.resolveClass(c);
            return c;
        }
    }

    static class DelayedFileOutputStream
    extends OutputStream {
        private FileOutputStream file = null;
        private String filename;

        DelayedFileOutputStream(String name) {
            this.filename = name;
        }

        private void init() throws IOException {
            if (this.file == null) {
                this.file = new FileOutputStream(this.filename);
            }
        }

        public void write(int b) throws IOException {
            this.init();
            this.file.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.init();
            this.file.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            this.file.write(b, off, len);
        }

        public void flush() throws IOException {
            this.init();
            this.file.flush();
        }

        public void close() throws IOException {
            this.init();
            this.file.close();
        }
    }
}

