/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;

public class TraceInterceptor
extends AbstractInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.getTargetClass(invocation).getName());
        buf.append("#");
        buf.append(invocation.getMethod().getName());
        buf.append("(");
        Object[] args = invocation.getArguments();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                buf.append(args[i]);
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        System.out.println("BEGIN " + buf);
        try {
            Object ret = invocation.proceed();
            buf.append(" : ");
            buf.append(ret);
            Object object = ret;
            return object;
        }
        catch (Throwable t) {
            buf.append(" Throwable:");
            buf.append(t);
            throw t;
        }
        finally {
            System.out.println("END " + buf);
        }
    }
}

