/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.TokenStream;
import org.codehaus.groovy.tools.ErrorReporter;

public class InteractiveShell {
    GroovyShell shell = new GroovyShell();
    BufferedReader reader;
    private StringBuffer accepted = new StringBuffer();
    private String pending = null;
    private int line = 1;
    private boolean stale = false;
    private SourceUnit parser = null;
    private TokenStream stream = null;
    private Exception error = null;
    private CSTNode tree = null;
    private static final int COMMAND_ID_EXIT = 0;
    private static final int COMMAND_ID_HELP = 1;
    private static final int COMMAND_ID_DISCARD = 2;
    private static final int COMMAND_ID_DISPLAY = 3;
    private static final int COMMAND_ID_EXPLAIN = 4;
    private static final int COMMAND_ID_EXECUTE = 5;
    private static final int LAST_COMMAND_ID = 5;
    private static final String[] COMMANDS = new String[]{"exit", "help", "discard", "display", "explain", "execute"};
    private static final Map COMMAND_MAPPINGS = new HashMap();
    private static final Map COMMAND_HELP;

    public static void main(String[] args) {
        try {
            InteractiveShell groovy = new InteractiveShell();
            groovy.run(args);
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public void run(String[] args) throws Exception {
        String command;
        this.reader = new BufferedReader(new InputStreamReader(System.in));
        String version = InvokerHelper.getVersion();
        System.out.println("Lets get Groovy!");
        System.out.println("================");
        System.out.println("Version: " + version + " JVM: " + System.getProperty("java.vm.version"));
        System.out.println("Type 'exit' to terminate the shell");
        System.out.println("Type 'help' for command help");
        int counter = 1;
        while ((command = this.read()) != null) {
            this.reset();
            if (command.length() <= 0) continue;
            try {
                Object answer = this.shell.evaluate(command, "CommandLine" + counter++ + ".groovy");
            }
            catch (Exception e) {
                new ErrorReporter(e, false).write(System.err);
            }
            catch (Throwable e) {
                new ErrorReporter(e, false).write(System.err);
                System.err.println(">>> exiting");
                System.exit(1);
            }
        }
    }

    protected void reset() {
        this.stale = true;
        this.pending = null;
        this.line = 1;
        this.parser = null;
        this.stream = null;
        this.error = null;
        this.tree = null;
    }

    protected String read() {
        this.reset();
        System.out.println("");
        boolean complete = false;
        boolean done = false;
        while (!done) {
            System.out.print(this.line + "> ");
            try {
                this.pending = this.reader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.pending == null || COMMAND_MAPPINGS.containsKey(this.pending) && (Integer)COMMAND_MAPPINGS.get(this.pending) == 0) {
                return null;
            }
            if (COMMAND_MAPPINGS.containsKey(this.pending)) {
                int code = (Integer)COMMAND_MAPPINGS.get(this.pending);
                switch (code) {
                    case 1: {
                        this.displayHelp();
                        break;
                    }
                    case 2: {
                        this.reset();
                        done = true;
                        break;
                    }
                    case 3: {
                        this.displayStatement();
                        break;
                    }
                    case 4: {
                        this.explainStatement();
                        break;
                    }
                    case 5: {
                        if (complete) {
                            done = true;
                            break;
                        }
                        System.err.println("statement not complete");
                    }
                }
                continue;
            }
            this.freshen();
            if (this.pending.trim() == "") {
                this.accept();
                continue;
            }
            String code = this.current();
            if (this.parse(code, 1)) {
                this.accept();
                complete = true;
                continue;
            }
            if (this.error == null) {
                this.accept();
                continue;
            }
            this.report();
        }
        return this.accepted(complete);
    }

    private String accepted(boolean complete) {
        if (complete) {
            return this.accepted.toString();
        }
        return "";
    }

    private String current() {
        return this.accepted.toString() + this.pending + "\n";
    }

    private void accept() {
        this.accepted.append(this.pending).append("\n");
        ++this.line;
    }

    private void freshen() {
        if (this.stale) {
            this.accepted.setLength(0);
            this.stale = false;
        }
    }

    private boolean parse(String code, int tolerance) {
        boolean parsed = false;
        this.parser = null;
        this.stream = null;
        this.error = null;
        this.tree = null;
        try {
            this.parser = SourceUnit.create("groovysh script", code, tolerance);
            this.parser.parse();
            this.tree = this.parser.getCST();
            parsed = true;
        }
        catch (CompilationFailedException e) {
            if (this.parser.getErrorCount() > 1 || !this.parser.failedWithUnexpectedEOF()) {
                this.error = e;
            }
        }
        catch (Exception e) {
            this.error = e;
        }
        return parsed;
    }

    private void report() {
        System.err.println("discarding invalid text:");
        new ErrorReporter(this.error, false).write(System.err);
    }

    private void displayHelp() {
        System.out.println("Available commands (must be entered without extraneous characters):");
        for (int i = 0; i <= 5; ++i) {
            System.out.println((String)COMMAND_HELP.get(COMMANDS[i]));
        }
    }

    private void displayStatement() {
        String[] lines = this.accepted.toString().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            System.out.println(i + 1 + "> " + lines[i]);
        }
    }

    private void explainStatement() {
        if (this.parse(this.accepted(true), 10) || this.error == null) {
            System.out.println("parse tree:");
            System.out.println(this.tree);
        } else {
            System.out.println("statement does not parse");
        }
    }

    static {
        for (int i = 0; i <= 5; ++i) {
            COMMAND_MAPPINGS.put(COMMANDS[i], new Integer(i));
        }
        COMMAND_MAPPINGS.put("quit", new Integer(0));
        COMMAND_MAPPINGS.put("go", new Integer(5));
        COMMAND_HELP = new HashMap();
        COMMAND_HELP.put(COMMANDS[0], "exit/quit  - terminates processing");
        COMMAND_HELP.put(COMMANDS[1], "help       - displays this help text");
        COMMAND_HELP.put(COMMANDS[2], "discard    - discards the current statement");
        COMMAND_HELP.put(COMMANDS[3], "display    - displays the current statement");
        COMMAND_HELP.put(COMMANDS[4], "explain    - explains the parsing of the current statement");
        COMMAND_HELP.put(COMMANDS[5], "execute/go - temporary command to cause statement execution");
    }
}

