/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import groovy.util.ResourceConnector;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyScriptEngine
implements ResourceConnector {
    private URL[] roots;
    private Map scriptCache = Collections.synchronizedMap(new HashMap());
    private ResourceConnector rc;

    public static void main(String[] args) throws Exception {
        URL[] roots = new URL[args.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = new File(args[i]).toURL();
        }
        GroovyScriptEngine gse = new GroovyScriptEngine(roots);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("groovy> ");
            String line = br.readLine();
            if (line == null || line.equals("quit")) break;
            try {
                System.out.println(gse.run(line, new Binding()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public URLConnection getResourceConnection(String resourceName) throws ResourceException {
        URLConnection groovyScriptConn = null;
        ResourceException se = null;
        for (int i = 0; i < this.roots.length; ++i) {
            String message;
            URL scriptURL = null;
            try {
                scriptURL = new URL(this.roots[i], resourceName);
                groovyScriptConn = scriptURL.openConnection();
                continue;
            }
            catch (MalformedURLException e) {
                message = "Malformed URL: " + this.roots[i] + ", " + resourceName;
                if (se == null) {
                    se = new ResourceException(message);
                    continue;
                }
                se = new ResourceException(message, se);
                continue;
            }
            catch (IOException e1) {
                message = "Cannot open URL: " + scriptURL;
                se = se == null ? new ResourceException(message) : new ResourceException(message, se);
            }
        }
        if (groovyScriptConn == null) {
            throw se;
        }
        return groovyScriptConn;
    }

    public GroovyScriptEngine(URL[] roots) {
        this.roots = roots;
        this.rc = this;
    }

    public GroovyScriptEngine(String[] args) throws IOException {
        URL[] roots = new URL[args.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = new File(args[i]).toURL();
        }
        this.rc = this;
    }

    public GroovyScriptEngine(String arg) throws IOException {
        this.roots = new URL[1];
        this.roots[0] = new File(arg).toURL();
        this.rc = this;
    }

    public GroovyScriptEngine(ResourceConnector rc) {
        this.rc = rc;
    }

    public String run(String script, String argument) throws ResourceException, ScriptException {
        Binding binding = new Binding();
        binding.setVariable("arg", argument);
        Object result = this.run(script, binding);
        return result == null ? "" : result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(String script, Binding binding) throws ResourceException, ScriptException {
        ScriptCacheEntry entry;
        String string = script = script.intern();
        synchronized (string) {
            URLConnection groovyScriptConn = this.rc.getResourceConnection(script);
            long lastModified = groovyScriptConn.getLastModified();
            entry = (ScriptCacheEntry)this.scriptCache.get(script);
            boolean dependencyOutOfDate = false;
            if (entry != null) {
                Iterator i = entry.dependencies.keySet().iterator();
                while (i.hasNext()) {
                    URLConnection urlc = null;
                    URL url = (URL)i.next();
                    try {
                        urlc = url.openConnection();
                        urlc.setDoInput(false);
                        urlc.setDoOutput(false);
                        long dependentLastModified = urlc.getLastModified();
                        if (dependentLastModified <= (Long)entry.dependencies.get(url)) continue;
                        dependencyOutOfDate = true;
                    }
                    catch (IOException ioe) {
                        dependencyOutOfDate = true;
                    }
                    break;
                }
            }
            if (entry == null || entry.lastModified < lastModified || dependencyOutOfDate) {
                final ScriptCacheEntry finalEntry = entry = new ScriptCacheEntry();
                GroovyClassLoader groovyLoader = (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new GroovyClassLoader(this, this.getClass().getClassLoader()){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                super(x0);
                            }

                            protected Class findClass(String className) throws ClassNotFoundException {
                                String filename = className.replace('.', File.separatorChar) + ".groovy";
                                URLConnection dependentScriptConn = null;
                                try {
                                    dependentScriptConn = GroovyScriptEngine.access$400(1.access$300(this.this$1)).getResourceConnection(filename);
                                    ScriptCacheEntry.access$000(1.access$500(this.this$1)).put(dependentScriptConn.getURL(), new Long(dependentScriptConn.getLastModified()));
                                }
                                catch (ResourceException e1) {
                                    throw new ClassNotFoundException("Could not read " + className + ": " + e1);
                                }
                                try {
                                    return this.parseClass(dependentScriptConn.getInputStream(), filename);
                                }
                                catch (CompilationFailedException e2) {
                                    throw new ClassNotFoundException("Syntax error in " + className + ": " + e2);
                                }
                                catch (IOException e2) {
                                    throw new ClassNotFoundException("Problem reading " + className + ": " + e2);
                                }
                            }
                        };
                    }

                    static /* synthetic */ GroovyScriptEngine access$300(1 x0) {
                        return x0.GroovyScriptEngine.this;
                    }

                    static /* synthetic */ ScriptCacheEntry access$500(1 x0) {
                        return x0.finalEntry;
                    }
                });
                try {
                    entry.scriptClass = groovyLoader.parseClass(groovyScriptConn.getInputStream(), script);
                }
                catch (Exception e) {
                    throw new ScriptException("Could not parse script: " + script, e);
                }
                entry.lastModified = lastModified;
                this.scriptCache.put(script, entry);
            }
        }
        Script scriptObject = InvokerHelper.createScript(entry.scriptClass, binding);
        return scriptObject.run();
    }

    static /* synthetic */ ResourceConnector access$400(GroovyScriptEngine x0) {
        return x0.rc;
    }

    private static class ScriptCacheEntry {
        private Class scriptClass;
        private long lastModified;
        private Map dependencies = new HashMap();

        private ScriptCacheEntry() {
        }
    }
}

