/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.GroovyRuntimeException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator2;

public abstract class Expression
extends ASTNode {
    protected boolean typeResolved = false;
    String failure = "";
    private boolean resolveFailed = false;
    public Class typeClass = null;
    protected String type = null;

    public boolean isResolveFailed() {
        return this.resolveFailed;
    }

    public void setResolveFailed(boolean resolveFailed) {
        this.resolveFailed = resolveFailed;
    }

    public String getFailure() {
        return this.failure;
    }

    public void setFailure(String failure) {
        this.failure = failure;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class typeClass) {
        if (typeClass != null) {
            this.typeClass = typeClass;
            this.type = typeClass.getName();
            this.setTypeResolved(true);
        }
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        Class cls = this.getTypeClass();
        return cls != null ? cls.getName() : null;
    }

    public boolean isDynamic() {
        return true;
    }

    public abstract Expression transformExpression(ExpressionTransformer var1);

    protected List transformExpressions(List expressions, ExpressionTransformer transformer) {
        ArrayList<Expression> list = new ArrayList<Expression>(expressions.size());
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            list.add(transformer.transform((Expression)iter.next()));
        }
        return list;
    }

    public void setType(String name) {
        if (name == null) {
            throw new GroovyRuntimeException("cannot set null on type");
        }
        if (name.equals("int")) {
            this.setTypeClass(Integer.TYPE);
            return;
        }
        if (name.equals("long")) {
            this.setTypeClass(Long.TYPE);
            return;
        }
        if (name.equals("short")) {
            this.setTypeClass(Short.TYPE);
            return;
        }
        if (name.equals("float")) {
            this.setTypeClass(Float.TYPE);
            return;
        }
        if (name.equals("double")) {
            this.setTypeClass(Double.TYPE);
            return;
        }
        if (name.equals("byte")) {
            this.setTypeClass(Byte.TYPE);
            return;
        }
        if (name.equals("char")) {
            this.setTypeClass(Character.TYPE);
            return;
        }
        if (name.equals("boolean")) {
            this.setTypeClass(Boolean.TYPE);
            return;
        }
        if (name.endsWith("[]")) {
            String prefix = "[";
            this.type = (name = name.substring(0, name.length() - 2)).equals("int") ? prefix + "I" : (name.equals("long") ? prefix + "J" : (name.equals("short") ? prefix + "S" : (name.equals("float") ? prefix + "F" : (name.equals("double") ? prefix + "D" : (name.equals("byte") ? prefix + "B" : (name.equals("char") ? prefix + "C" : (name.equals("boolean") ? prefix + "Z" : prefix + "L" + name + ";")))))));
        } else {
            this.type = name;
        }
        if (this.type == null) {
            System.out.println("Expression.setType(): null");
            System.out.println("name = " + name);
        }
        try {
            this.setTypeClass(Class.forName(this.type, false, this.getClass().getClassLoader()));
        }
        catch (Throwable e) {
            this.typeResolved = false;
        }
    }

    public boolean isTypeResolved() {
        return this.typeResolved;
    }

    public void setTypeResolved(boolean b) {
        this.typeResolved = b;
        this.resolveFailed = false;
    }

    public void resolve(AsmClassGenerator2 cg) {
        if (this.shouldContinue()) {
            this.resolveType(cg);
        }
    }

    protected abstract void resolveType(AsmClassGenerator2 var1);

    protected boolean shouldContinue() {
        return !this.isResolveFailed() && !this.isTypeResolved();
    }
}

