/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import org.apache.axis.components.encoding.AbstractXMLEncoder;
import org.apache.axis.components.encoding.EncodedByteArray;

class UTF8Encoder
extends AbstractXMLEncoder {
    UTF8Encoder() {
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public boolean needsEncoding(char c) {
        return c > '\u007f';
    }

    public void appendEncoded(EncodedByteArray out, char c) {
        if (c < '\u0080') {
            out.append(c);
        } else if (c < '\u0800') {
            out.append(0xC0 | c >> 6);
            out.append(0x80 | c & 0x3F);
        } else if (c < '\u10000') {
            out.append(0xE0 | c >> 12);
            out.append(0x80 | c >> 6 & 0x3F);
            out.append(0x80 | c & 0x3F);
        } else if (c < '\u200000') {
            out.append(0xF0 | c >> 18);
            out.append(0x80 | c >> 12 & 0x3F);
            out.append(0x80 | c >> 6 & 0x3F);
            out.append(0x80 | c & 0x3F);
        }
    }
}

