package test.org.seasar.extension.j2ee;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.extension.j2ee.JndiContextFactory;

public class JndiContextFactoryTest extends TestCase {

	private static final String PATH =
		"test/org/seasar/extension/j2ee/jndi.dicon";
	private Context ctx_;

	public JndiContextFactoryTest(String name) {
		super(name);
	}

	public void testLookup() throws Exception {
		assertNotNull("1", ctx_.lookup("jndi.transactionManager"));
		assertNotNull("2", ctx_.lookup("jndi.dataSource"));
	}

	protected void setUp() throws Exception {
		Hashtable env = new Hashtable();
		env.put(Context.INITIAL_CONTEXT_FACTORY, JndiContextFactory.class.getName());
		env.put(Context.PROVIDER_URL, PATH);
		ctx_ = new InitialContext(env);
	}

	protected void tearDown() throws Exception {
		ctx_.close();
	}

	public static Test suite() {
		return new TestSuite(JndiContextFactoryTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { JndiContextFactoryTest.class.getName()});
	}
}