/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.parser;

import org.seasar.dao.SqlTokenizer;
import org.seasar.dao.TokenNotClosedRuntimeException;

public class SqlTokenizerImpl
implements SqlTokenizer {
    private String sql_;
    private int position_ = 0;
    private String token_;
    private int tokenType_ = 1;
    private int nextTokenType_ = 1;
    private int bindVariableNum = 0;

    public SqlTokenizerImpl(String sql) {
        this.sql_ = sql;
    }

    public int getPosition() {
        return this.position_;
    }

    public String getToken() {
        return this.token_;
    }

    public String getBefore() {
        return this.sql_.substring(0, this.position_);
    }

    public String getAfter() {
        return this.sql_.substring(this.position_);
    }

    public int getTokenType() {
        return this.tokenType_;
    }

    public int getNextTokenType() {
        return this.nextTokenType_;
    }

    public int next() {
        if (this.position_ >= this.sql_.length()) {
            this.token_ = null;
            this.tokenType_ = 99;
            this.nextTokenType_ = 99;
            return this.tokenType_;
        }
        switch (this.nextTokenType_) {
            case 1: {
                this.parseSql();
                break;
            }
            case 2: {
                this.parseComment();
                break;
            }
            case 3: {
                this.parseElse();
                break;
            }
            case 4: {
                this.parseBindVariable();
                break;
            }
            default: {
                this.parseEof();
            }
        }
        return this.tokenType_;
    }

    protected void parseSql() {
        int nextStartPos;
        int skipPos;
        int commentStartPos = this.sql_.indexOf("/*", this.position_);
        int lineCommentStartPos = this.sql_.indexOf("--", this.position_);
        int bindVariableStartPos = this.sql_.indexOf("?", this.position_);
        int elseCommentStartPos = -1;
        int elseCommentLength = -1;
        if (lineCommentStartPos >= 0 && (skipPos = this.skipWhitespace(lineCommentStartPos + 2)) + 4 < this.sql_.length() && "ELSE".equals(this.sql_.substring(skipPos, skipPos + 4))) {
            elseCommentStartPos = lineCommentStartPos;
            elseCommentLength = skipPos + 4 - lineCommentStartPos;
        }
        if ((nextStartPos = this.getNextStartPos(commentStartPos, elseCommentStartPos, bindVariableStartPos)) < 0) {
            this.token_ = this.sql_.substring(this.position_);
            this.nextTokenType_ = 99;
            this.position_ = this.sql_.length();
            this.tokenType_ = 1;
        } else {
            boolean needNext;
            this.token_ = this.sql_.substring(this.position_, nextStartPos);
            this.tokenType_ = 1;
            boolean bl = needNext = nextStartPos == this.position_;
            if (nextStartPos == commentStartPos) {
                this.nextTokenType_ = 2;
                this.position_ = commentStartPos + 2;
            } else if (nextStartPos == elseCommentStartPos) {
                this.nextTokenType_ = 3;
                this.position_ = elseCommentStartPos + elseCommentLength;
            } else if (nextStartPos == bindVariableStartPos) {
                this.nextTokenType_ = 4;
                this.position_ = bindVariableStartPos;
            }
            if (needNext) {
                this.next();
            }
        }
    }

    protected int getNextStartPos(int commentStartPos, int elseCommentStartPos, int bindVariableStartPos) {
        int nextStartPos = -1;
        if (commentStartPos >= 0) {
            nextStartPos = commentStartPos;
        }
        if (elseCommentStartPos >= 0 && (nextStartPos < 0 || elseCommentStartPos < nextStartPos)) {
            nextStartPos = elseCommentStartPos;
        }
        if (bindVariableStartPos >= 0 && (nextStartPos < 0 || bindVariableStartPos < nextStartPos)) {
            nextStartPos = bindVariableStartPos;
        }
        return nextStartPos;
    }

    protected String nextBindVariableName() {
        return "$" + ++this.bindVariableNum;
    }

    protected void parseComment() {
        int commentEndPos = this.sql_.indexOf("*/", this.position_);
        if (commentEndPos < 0) {
            throw new TokenNotClosedRuntimeException("*/", this.sql_.substring(this.position_));
        }
        this.token_ = this.sql_.substring(this.position_, commentEndPos);
        this.nextTokenType_ = 1;
        this.position_ = commentEndPos + 2;
        this.tokenType_ = 2;
    }

    protected void parseBindVariable() {
        this.token_ = this.nextBindVariableName();
        this.nextTokenType_ = 1;
        ++this.position_;
        this.tokenType_ = 4;
    }

    protected void parseElse() {
        this.token_ = null;
        this.nextTokenType_ = 1;
        this.tokenType_ = 3;
    }

    protected void parseEof() {
        this.token_ = null;
        this.tokenType_ = 99;
        this.nextTokenType_ = 99;
    }

    public String skipToken() {
        boolean quoting;
        int index = this.sql_.length();
        char quote = this.position_ < this.sql_.length() ? this.sql_.charAt(this.position_) : (char)'\u0000';
        boolean bl = quoting = quote == '\'' || quote == '(';
        if (quote == '(') {
            quote = ')';
        }
        int i = quoting ? this.position_ + 1 : this.position_;
        while (i < this.sql_.length()) {
            char c = this.sql_.charAt(i);
            if ((Character.isWhitespace(c) || c == ',') && !quoting) {
                index = i;
                break;
            }
            if (c == '/' && i + 1 < this.sql_.length() && this.sql_.charAt(i + 1) == '*') {
                index = i;
                break;
            }
            if (c == '-' && i + 1 < this.sql_.length() && this.sql_.charAt(i + 1) == '-') {
                index = i;
                break;
            }
            if (quoting && c == '\'' && (i + 1 >= this.sql_.length() || this.sql_.charAt(i + 1) != '\'')) {
                index = i + 1;
                break;
            }
            if (quoting && c == quote) {
                index = i + 1;
                break;
            }
            ++i;
        }
        this.token_ = this.sql_.substring(this.position_, index);
        this.tokenType_ = 1;
        this.nextTokenType_ = 1;
        this.position_ = index;
        return this.token_;
    }

    public String skipWhitespace() {
        int index = this.skipWhitespace(this.position_);
        this.token_ = this.sql_.substring(this.position_, index);
        this.position_ = index;
        return this.token_;
    }

    private int skipWhitespace(int position) {
        int index = this.sql_.length();
        int i = position;
        while (i < this.sql_.length()) {
            char c = this.sql_.charAt(i);
            if (!Character.isWhitespace(c)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }
}

