package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.UpdateFailureRuntimeException;

/**
 * @author higa
 *  
 */
public abstract class AbstractAutoStaticCommand extends AbstractStaticCommand {

	public AbstractAutoStaticCommand(DataSource dataSource,
			BeanMetaData beanMetaData) {

		super(dataSource, beanMetaData);
	}

	public Object execute(Object[] args) {
		AbstractAutoHandler handler = createAutoHandler();
		int updatedRows = handler.execute(args);
		if (updatedRows != 1) {
			throw new UpdateFailureRuntimeException(args[0]);
		}
		return new Integer(updatedRows);
	}

	protected abstract AbstractAutoHandler createAutoHandler();
}