/*
 * 쐬F 2004/09/30
 */
package org.seasar.tapestry.junk;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

import org.apache.tapestry.html.BasePage;

/**
 * @author maruo_syunsuke
 */
public class NullObjectFactory implements InvocationHandler {
	
	private NullObjectFactory() {
	}

	public static Object createNullObject(Class inf) {
		if( inf.isInterface() ) {
			return Proxy.newProxyInstance(inf.getClassLoader(), 
					new Class[]{inf}, new NullObjectFactory() );
		}else {
			return Proxy.newProxyInstance(inf.getClassLoader(), 
					inf.getInterfaces(), new NullObjectFactory() );
		}
	}

	public static void main(String[] args) {
		List obj = (List)createNullObject(ArrayList.class);
		System.out.println(obj.get(0));
	}
	/**
	 * @see java.lang.reflect.InvocationHandler#invoke(java.lang.Object, java.lang.reflect.Method, java.lang.Object[])
	 */
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		return null ;
	}
}
