/*
 * 쐬F 2004/09/03
 */
package org.seasar.tapestry.pageinjection.impl;


import java.util.List;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.tapestry.pageinjection.Injection;

/**
 * @author maruo_syunsuke
 */
public class TopInjectionTest extends S2TestCase {

	/**
	 * Constructor for TopInjectionTest.
	 * @param arg0
	 */
	public TopInjectionTest(String arg0) {
		super(arg0);
	}
	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		include("TopInjectionTest.dicon");
	}
	public void testInjection() {
		T3 t3 = new T3();
		
		assertNull("DIO1", t3.getList1());
		assertNull("DIO2", t3.getList2());
		assertNull("DIO3", t3.getList3());
		
		Injection injection = (Injection)getComponent(Injection.class);
		injection.invoke(t3);
		List lst = (List)getComponent(List.class);
		
		assertNull("DI1", t3.getList1());
		assertNull("DI2", t3.getList2());
		assertEquals("DI3", lst, t3.getList3());
	}
}

