/*
 * 쐬F 2004/09/13
 */
package org.seasar.tapestry.util;

import junit.framework.TestCase;

/**
 * @author maruo_syunsuke
 */
public class BeanCopyTest extends TestCase {
	BeanCopy target ;
	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		target = new BeanCopy();
	}
	public void testCopyBean(){
		TestA expected = new TestA();
		TestB actual = new TestB();
		target.beanCopy(actual, expected);
		assertEquals("AtoB", expected.toString(), actual.toString());
	}
	public void testCopyBeanBetweenString(){
		TestA expected = new TestA();
		TestC actual1 = new TestC();
		target.beanCopy(actual1, expected, bindC.class);
		assertEquals("AtoC", expected.toString(), actual1.toString());

		TestD actual2 = new TestD();
		target.beanCopy(actual2, expected, bindD.class);
		assertEquals("AtoD", expected.toString(), actual2.toString());
	}
}
class TestA{
	private int one = 1 ;
	private int twe = 2 ;
	private int three = 3 ;
	
	public int getOne() {
		return this.one;
	}
	public void setOne(int one) {
		this.one = one;
	}
	public int getThree() {
		return this.three;
	}
	public void setThree(int three) {
		this.three = three;
	}
	public int getTwe() {
		return this.twe;
	}
	public void setTwe(int twe) {
		this.twe = twe;
	}
	public String toString() {
		return ""+one+"+"+twe+"+"+three;
	}
}
class TestB{
	private int one  ;
	private int twe  ;
	private int three ;
	
	public int getOne() {
		return this.one;
	}
	public void setOne(int one) {
		this.one = one;
	}
	public int getThree() {
		return this.three;
	}
	public void setThree(int three) {
		this.three = three;
	}
	public int getTwe() {
		return this.twe;
	}
	public void setTwe(int twe) {
		this.twe = twe;
	}
	public String toString() {
		return ""+one+"+"+twe+"+"+three;
	}
}
class TestC{
	private int iti  ;
	private int ni  ;
	private int san ;
	
	public int getIti() {
		return this.iti;
	}
	public void setIti(int iti) {
		this.iti = iti;
	}
	public int getNi() {
		return this.ni;
	}
	public void setNi(int ni) {
		this.ni = ni;
	}
	public int getSan() {
		return this.san;
	}
	public void setSan(int san) {
		this.san = san;
	}
	public String toString() {
		return ""+iti+"+"+ni+"+"+san;
	}
}
class bindC{
	public final static String one = "iti";
	public final static String twe = "ni";
	public final static String three = "san" ;
}
class TestD{
	private int iti  ;
	private int twe  ;
	private int san ;
	
	public int getIti() {
		return this.iti;
	}
	public void setIti(int iti) {
		this.iti = iti;
	}
	public int getTwe() {
		return this.twe;
	}
	public void setTwe(int ni) {
		this.twe = ni;
	}
	public int getSan() {
		return this.san;
	}
	public void setSan(int san) {
		this.san = san;
	}
	public String toString() {
		return ""+iti+"+"+twe+"+"+san;
	}
}
class bindD{
	public final static String one = "iti";
	public final static String three = "san" ;
}
