package org.seasar.extension.mock.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;

public class MockServletOutputStream extends ServletOutputStream {

	private PrintWriter writer_;
	
	public MockServletOutputStream(PrintWriter writer) {
		setPrintWriter(writer);
	}

	public PrintWriter getPrintWriter() {
		return writer_;
	}

	public void setPrintWriter(PrintWriter writer) {
		writer_ = writer;
	}

	public void write(int b) throws IOException {
		writer_.write(b);
	}
	
	public String toString() {
		if (writer_ != null) {
			return writer_.toString();
		}
		return super.toString();
	}
}